/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import java.util.Collection;
import java.util.Map;
import org.duracloud.appconfig.domain.AppConfig;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.model.RootUserCredential;
import org.duracloud.common.util.ExceptionUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.xml.SecurityUsersDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private final Logger log = LoggerFactory.getLogger(Application.class);
    private String host;
    private String port;
    private String context;
    private RestHttpHelper restHelper;

    public Application(String host, String port, String context) {
        this.host = host;
        this.port = port;
        this.context = context;
    }

    public Application(String host, String port, String context, RestHttpHelper restHelper) {
        this.host = host;
        this.port = port;
        this.context = context;
        this.restHelper = restHelper;
    }

    public RestHttpHelper.HttpResponse initialize(AppConfig config) {
        String xml = config.asXml();
        String url = this.getInitUrl(config);
        try {
            Map headers = null;
            return this.getRestHelper().post(url, xml, headers);
        }
        catch (Exception e) {
            this.log.error("error initializing app at: " + url, (Object)ExceptionUtil.getStackTraceAsString((Throwable)e));
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    public RestHttpHelper.HttpResponse setSecurityUsers(Collection<SecurityUserBean> users) {
        String xml = SecurityUsersDocumentBinding.createDocumentFrom(users);
        try {
            Map headers = null;
            return this.getRestHelper().post(this.getSecurityUrl(), xml, headers);
        }
        catch (Exception e) {
            this.log.error("error initializing durastore security", (Object)ExceptionUtil.getStackTraceAsString((Throwable)e));
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    private String getInitUrl(AppConfig config) {
        return this.getBaseUrl() + config.getInitResource();
    }

    protected String getBaseUrl() {
        return this.getProtocol() + this.getHost() + ":" + this.getPort() + "/" + this.getContext();
    }

    private String getProtocol() {
        String protocol = "http://";
        if (this.getPort().equals("443")) {
            protocol = "https://";
        }
        return protocol;
    }

    private String getSecurityUrl() {
        return this.getBaseUrl() + "/security";
    }

    protected RestHttpHelper getRestHelper() {
        if (null == this.restHelper) {
            this.restHelper = new RestHttpHelper((Credential)new RootUserCredential());
        }
        return this.restHelper;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getContext() {
        return this.context;
    }
}

