/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalSecondaryIndex
implements Serializable,
Cloneable {
    private String indexName;
    private List<KeySchemaElement> keySchema;
    private Projection projection;

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public LocalSecondaryIndex withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public LocalSecondaryIndex withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public LocalSecondaryIndex withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public LocalSecondaryIndex withProjection(Projection projection) {
        this.setProjection(projection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            sb.append("Projection: " + this.getProjection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndex)) {
            return false;
        }
        LocalSecondaryIndex other = (LocalSecondaryIndex)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        return other.getProjection() == null || other.getProjection().equals(this.getProjection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        return hashCode;
    }

    public LocalSecondaryIndex clone() {
        try {
            return (LocalSecondaryIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

