/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.HostVolumeProperties;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.VolumeFrom;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RegisterTaskDefinitionRequestMarshaller
implements Marshaller<Request<RegisterTaskDefinitionRequest>, RegisterTaskDefinitionRequest> {
    @Override
    public Request<RegisterTaskDefinitionRequest> marshall(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        if (registerTaskDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterTaskDefinitionRequest> request = new DefaultRequest<RegisterTaskDefinitionRequest>(registerTaskDefinitionRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag volumesList;
            ListWithAutoConstructFlag containerDefinitionsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (registerTaskDefinitionRequest.getFamily() != null) {
                jsonWriter.key("family").value(registerTaskDefinitionRequest.getFamily());
            }
            if (!((containerDefinitionsList = (ListWithAutoConstructFlag)registerTaskDefinitionRequest.getContainerDefinitions()) == null || containerDefinitionsList.isAutoConstruct() && containerDefinitionsList.isEmpty())) {
                jsonWriter.key("containerDefinitions");
                jsonWriter.array();
                for (ContainerDefinition containerDefinitionsListValue : containerDefinitionsList) {
                    ListWithAutoConstructFlag volumesFromList;
                    ListWithAutoConstructFlag mountPointsList;
                    ListWithAutoConstructFlag environmentList;
                    ListWithAutoConstructFlag commandList;
                    ListWithAutoConstructFlag entryPointList;
                    ListWithAutoConstructFlag portMappingsList;
                    ListWithAutoConstructFlag linksList;
                    if (containerDefinitionsListValue == null) continue;
                    jsonWriter.object();
                    if (containerDefinitionsListValue.getName() != null) {
                        jsonWriter.key("name").value(containerDefinitionsListValue.getName());
                    }
                    if (containerDefinitionsListValue.getImage() != null) {
                        jsonWriter.key("image").value(containerDefinitionsListValue.getImage());
                    }
                    if (containerDefinitionsListValue.getCpu() != null) {
                        jsonWriter.key("cpu").value(containerDefinitionsListValue.getCpu());
                    }
                    if (containerDefinitionsListValue.getMemory() != null) {
                        jsonWriter.key("memory").value(containerDefinitionsListValue.getMemory());
                    }
                    if (!((linksList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getLinks()) == null || linksList.isAutoConstruct() && linksList.isEmpty())) {
                        jsonWriter.key("links");
                        jsonWriter.array();
                        for (String linksListValue : linksList) {
                            if (linksListValue == null) continue;
                            jsonWriter.value(linksListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((portMappingsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getPortMappings()) == null || portMappingsList.isAutoConstruct() && portMappingsList.isEmpty())) {
                        jsonWriter.key("portMappings");
                        jsonWriter.array();
                        for (PortMapping portMappingsListValue : portMappingsList) {
                            if (portMappingsListValue == null) continue;
                            jsonWriter.object();
                            if (portMappingsListValue.getContainerPort() != null) {
                                jsonWriter.key("containerPort").value(portMappingsListValue.getContainerPort());
                            }
                            if (portMappingsListValue.getHostPort() != null) {
                                jsonWriter.key("hostPort").value(portMappingsListValue.getHostPort());
                            }
                            if (portMappingsListValue.getProtocol() != null) {
                                jsonWriter.key("protocol").value(portMappingsListValue.getProtocol());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (containerDefinitionsListValue.isEssential() != null) {
                        jsonWriter.key("essential").value(containerDefinitionsListValue.isEssential());
                    }
                    if (!((entryPointList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getEntryPoint()) == null || entryPointList.isAutoConstruct() && entryPointList.isEmpty())) {
                        jsonWriter.key("entryPoint");
                        jsonWriter.array();
                        for (String entryPointListValue : entryPointList) {
                            if (entryPointListValue == null) continue;
                            jsonWriter.value(entryPointListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((commandList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getCommand()) == null || commandList.isAutoConstruct() && commandList.isEmpty())) {
                        jsonWriter.key("command");
                        jsonWriter.array();
                        for (String commandListValue : commandList) {
                            if (commandListValue == null) continue;
                            jsonWriter.value(commandListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((environmentList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getEnvironment()) == null || environmentList.isAutoConstruct() && environmentList.isEmpty())) {
                        jsonWriter.key("environment");
                        jsonWriter.array();
                        for (KeyValuePair environmentListValue : environmentList) {
                            if (environmentListValue == null) continue;
                            jsonWriter.object();
                            if (environmentListValue.getName() != null) {
                                jsonWriter.key("name").value(environmentListValue.getName());
                            }
                            if (environmentListValue.getValue() != null) {
                                jsonWriter.key("value").value(environmentListValue.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((mountPointsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getMountPoints()) == null || mountPointsList.isAutoConstruct() && mountPointsList.isEmpty())) {
                        jsonWriter.key("mountPoints");
                        jsonWriter.array();
                        for (MountPoint mountPointsListValue : mountPointsList) {
                            if (mountPointsListValue == null) continue;
                            jsonWriter.object();
                            if (mountPointsListValue.getSourceVolume() != null) {
                                jsonWriter.key("sourceVolume").value(mountPointsListValue.getSourceVolume());
                            }
                            if (mountPointsListValue.getContainerPath() != null) {
                                jsonWriter.key("containerPath").value(mountPointsListValue.getContainerPath());
                            }
                            if (mountPointsListValue.isReadOnly() != null) {
                                jsonWriter.key("readOnly").value(mountPointsListValue.isReadOnly());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((volumesFromList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getVolumesFrom()) == null || volumesFromList.isAutoConstruct() && volumesFromList.isEmpty())) {
                        jsonWriter.key("volumesFrom");
                        jsonWriter.array();
                        for (VolumeFrom volumesFromListValue : volumesFromList) {
                            if (volumesFromListValue == null) continue;
                            jsonWriter.object();
                            if (volumesFromListValue.getSourceContainer() != null) {
                                jsonWriter.key("sourceContainer").value(volumesFromListValue.getSourceContainer());
                            }
                            if (volumesFromListValue.isReadOnly() != null) {
                                jsonWriter.key("readOnly").value(volumesFromListValue.isReadOnly());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((volumesList = (ListWithAutoConstructFlag)registerTaskDefinitionRequest.getVolumes()) == null || volumesList.isAutoConstruct() && volumesList.isEmpty())) {
                jsonWriter.key("volumes");
                jsonWriter.array();
                for (Volume volumesListValue : volumesList) {
                    HostVolumeProperties host;
                    if (volumesListValue == null) continue;
                    jsonWriter.object();
                    if (volumesListValue.getName() != null) {
                        jsonWriter.key("name").value(volumesListValue.getName());
                    }
                    if ((host = volumesListValue.getHost()) != null) {
                        jsonWriter.key("host");
                        jsonWriter.object();
                        if (host.getSourcePath() != null) {
                            jsonWriter.key("sourcePath").value(host.getSourcePath());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

