/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.services.importexport.model.Job;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class JobStaxUnmarshaller
implements Unmarshaller<Job, StaxUnmarshallerContext> {
    private static JobStaxUnmarshaller instance;

    @Override
    public Job unmarshall(StaxUnmarshallerContext context) throws Exception {
        Job job = new Job();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return job;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("JobId", targetDepth)) {
                    job.setJobId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    job.setCreationDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsCanceled", targetDepth)) {
                    job.setIsCanceled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("JobType", targetDepth)) continue;
                job.setJobType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return job;
    }

    public static JobStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new JobStaxUnmarshaller();
        }
        return instance;
    }
}

