/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.storage.domain.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfig {
    private final Logger log = LoggerFactory.getLogger(BaseConfig.class);

    public void load(Map<String, String> props) {
        if (props != null && props.size() > 0) {
            for (String key : props.keySet()) {
                if (!this.isSupported(key)) continue;
                String suffix = this.getSuffix(key);
                String value = props.get(key);
                this.loadProperty(suffix, value);
            }
        }
    }

    protected boolean isSupported(String key) {
        return key != null && key.startsWith(this.getQualifier());
    }

    protected abstract String getQualifier();

    protected abstract void loadProperty(String var1, String var2);

    protected String getPrefix(String key) {
        String prefix = key;
        int index = key.indexOf(".");
        if (index != -1) {
            prefix = key.substring(0, key.indexOf("."));
        }
        if (StringUtils.isBlank(prefix)) {
            String msg = "prefix not found: " + key;
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        return prefix;
    }

    protected String getSuffix(String key) {
        String suffix = key;
        String prefix = this.getPrefix(key);
        if (!suffix.equals(prefix)) {
            suffix = key.substring(this.getPrefix(key).length() + 1);
        }
        if (StringUtils.isBlank(suffix)) {
            String msg = "suffix not found: " + key;
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        return suffix;
    }

    protected void loadDbConfig(DatabaseConfig databaseConfig, String key, String value) {
        String suffix = this.getSuffix(key);
        if (suffix.equalsIgnoreCase("username")) {
            databaseConfig.setUsername(value);
        } else if (suffix.equalsIgnoreCase("password")) {
            databaseConfig.setPassword(value);
        } else if (suffix.equalsIgnoreCase("host")) {
            databaseConfig.setHost(value);
        } else if (suffix.equalsIgnoreCase("port")) {
            databaseConfig.setPort(Integer.parseInt(value));
        } else if (suffix.equalsIgnoreCase("name")) {
            databaseConfig.setName(value);
        }
    }
}

