/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.audit.task;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.queue.task.Task;
import org.duracloud.common.queue.task.TypedTask;

public class AuditTask
extends TypedTask {
    public static final String ACTION_PROP = "action";
    public static final String USER_ID_PROP = "user-id";
    public static final String DATE_TIME_PROP = "date-time";
    public static final String CONTENT_CHECKSUM_PROP = "content-checksum";
    public static final String CONTENT_MIMETYPE_PROP = "content-mimetype";
    public static final String CONTENT_SIZE_PROP = "content-size";
    public static final String CONTENT_RANGE_PROP = "content-range";
    public static final String CONTENT_PROPERTIES_PROP = "content-properties";
    public static final String SPACE_ACLS_PROP = "space-acls";
    public static final String STORE_TYPE_PROP = "store-type";
    public static final String SOURCE_SPACE_ID_PROP = "source-space-id";
    public static final String SOURCE_CONTENT_ID_PROP = "source-content-id";
    private String action;
    private String userId;
    private String dateTime;
    private String contentChecksum;
    private String contentMimetype;
    private String contentSize;
    private String contentRange;
    private Map<String, String> contentProperties;
    private String spaceACLs;
    private String storeType;
    private String sourceSpaceId;
    private String sourceContentId;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        ActionType.valueOf(action);
        this.action = action;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getContentChecksum() {
        return this.contentChecksum;
    }

    public void setContentChecksum(String contentChecksum) {
        this.contentChecksum = contentChecksum;
    }

    public String getContentMimetype() {
        return this.contentMimetype;
    }

    public void setContentMimetype(String contentMimetype) {
        this.contentMimetype = contentMimetype;
    }

    public String getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(String contentSize) {
        this.contentSize = contentSize;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public void setContentRange(String contentRange) {
        this.contentRange = contentRange;
    }

    public Map<String, String> getContentProperties() {
        return this.contentProperties;
    }

    public void setContentProperties(Map<String, String> contentProperties) {
        this.contentProperties = contentProperties;
    }

    public String getSpaceACLs() {
        return this.spaceACLs;
    }

    public void setSpaceACLs(String spaceACLs) {
        this.spaceACLs = spaceACLs;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getSourceSpaceId() {
        return this.sourceSpaceId;
    }

    public void setSourceSpaceId(String sourceSpaceId) {
        this.sourceSpaceId = sourceSpaceId;
    }

    public String getSourceContentId() {
        return this.sourceContentId;
    }

    public void setSourceContentId(String sourceContentId) {
        this.sourceContentId = sourceContentId;
    }

    public void readTask(Task task) {
        super.readTask(task);
        Map props = task.getProperties();
        this.setAction((String)props.get(ACTION_PROP));
        this.setUserId((String)props.get(USER_ID_PROP));
        this.setDateTime((String)props.get(DATE_TIME_PROP));
        this.setContentChecksum((String)props.get(CONTENT_CHECKSUM_PROP));
        this.setContentMimetype((String)props.get(CONTENT_MIMETYPE_PROP));
        this.setContentSize((String)props.get(CONTENT_SIZE_PROP));
        Map<String, String> contentProps = AuditTask.deserializeContentProperties((String)props.get(CONTENT_PROPERTIES_PROP));
        this.setContentProperties(contentProps);
        this.setSpaceACLs((String)props.get(SPACE_ACLS_PROP));
        this.setStoreType((String)props.get(STORE_TYPE_PROP));
        this.setSourceSpaceId((String)props.get(SOURCE_SPACE_ID_PROP));
        this.setSourceContentId((String)props.get(SOURCE_CONTENT_ID_PROP));
    }

    public Task writeTask() {
        Task task = super.writeTask();
        task.setType(Task.Type.AUDIT);
        this.addProperty(task, ACTION_PROP, this.getAction());
        this.addProperty(task, USER_ID_PROP, this.getUserId());
        this.addProperty(task, DATE_TIME_PROP, this.getDateTime());
        this.addProperty(task, CONTENT_CHECKSUM_PROP, this.getContentChecksum());
        this.addProperty(task, CONTENT_MIMETYPE_PROP, this.getContentMimetype());
        this.addProperty(task, CONTENT_SIZE_PROP, this.getContentSize());
        this.addProperty(task, CONTENT_RANGE_PROP, this.getContentRange());
        String contentProps = AuditTask.serializeContentProperties(this.getContentProperties());
        this.addProperty(task, CONTENT_PROPERTIES_PROP, contentProps);
        this.addProperty(task, SPACE_ACLS_PROP, this.spaceACLs);
        this.addProperty(task, STORE_TYPE_PROP, this.getStoreType());
        this.addProperty(task, SOURCE_SPACE_ID_PROP, this.getSourceSpaceId());
        this.addProperty(task, SOURCE_CONTENT_ID_PROP, this.getSourceContentId());
        return task;
    }

    protected static Map<String, String> deserializeContentProperties(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (Map)AuditTask.getPropsSerializer().deserialize(json);
            }
            catch (IOException e) {
                throw new DuraCloudRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    protected static String serializeContentProperties(Map<String, String> props) {
        if (props != null) {
            try {
                return AuditTask.getPropsSerializer().serialize(props);
            }
            catch (IOException e) {
                throw new DuraCloudRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    private static JaxbJsonSerializer<Map<String, String>> getPropsSerializer() {
        return new JaxbJsonSerializer(new HashMap().getClass());
    }

    public static enum ActionType {
        CREATE_SPACE,
        DELETE_SPACE,
        SET_SPACE_ACLS,
        ADD_CONTENT,
        COPY_CONTENT,
        DELETE_CONTENT,
        SET_CONTENT_PROPERTIES,
        GET_SPACES,
        GET_SPACE_CONTENTS,
        GET_SPACE_CONTENTS_CHUNKED,
        GET_SPACE_PROPERTIES,
        GET_SPACE_ACLS,
        GET_CONTENT,
        GET_CONTENT_PROPERTIES;

    }
}

