/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.DigestInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.chunk.ChunkableContent;
import org.duracloud.chunk.FileChunkerOptions;
import org.duracloud.chunk.error.NotFoundException;
import org.duracloud.chunk.stream.ChunkInputStream;
import org.duracloud.chunk.writer.AddContentResult;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChunker {
    private final Logger log = LoggerFactory.getLogger(FileChunker.class);
    private ContentWriter contentWriter;
    private FileChunkerOptions options;

    public FileChunker(ContentWriter contentWriter) {
        this(contentWriter, new FileChunkerOptions());
    }

    public FileChunker(ContentWriter contentWriter, FileChunkerOptions options) {
        this.contentWriter = contentWriter;
        this.options = options;
    }

    protected void writeReport(File outputFile) {
        StringBuilder sb = new StringBuilder();
        if (!outputFile.exists()) {
            sb.append("spaceId,contentId,md5,size,state\n");
        }
        OutputStream outputStream = this.getOutputStream(outputFile);
        List<AddContentResult> results = this.contentWriter.getResults();
        for (AddContentResult result : results) {
            sb.append(result.getSpaceId());
            sb.append(",");
            sb.append(result.getContentId());
            sb.append(",");
            sb.append(result.getMd5());
            sb.append(",");
            sb.append(result.getContentSize());
            sb.append(",");
            sb.append(result.getState().name());
            sb.append("\n");
        }
        try {
            outputStream.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private OutputStream getOutputStream(File outputFile) {
        boolean append = true;
        try {
            return new FileOutputStream(outputFile, append);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    public void addContent(String destSpaceId, String destContentId, String fileChecksum, File file) {
        this.addContent(destSpaceId, destContentId, fileChecksum, file.length(), this.getInputStream(file));
    }

    public void addContent(String destSpaceId, String destContentId, String fileChecksum, long fileSize, InputStream stream) {
        try {
            this.doAddContent(destSpaceId, destContentId, fileChecksum, fileSize, this.getInputStream(stream));
        }
        catch (NotFoundException e) {
            throw new DuraCloudRuntimeException((Throwable)((Object)e));
        }
    }

    protected void addContentFrom(File baseDir, String destSpaceId) {
        Collection<File> files = this.listFiles(baseDir, this.options.getFileFilter(), this.options.getDirFilter());
        for (File file : files) {
            try {
                this.doAddContent(baseDir, destSpaceId, file);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder("Error: ");
                sb.append("Unable to addContentFrom [");
                sb.append(baseDir);
                sb.append(", ");
                sb.append(destSpaceId);
                sb.append("] : ");
                sb.append(e.getMessage());
                sb.append("\n");
                sb.append(ExceptionUtil.getStackTraceAsString((Throwable)e));
                this.log.error(sb.toString());
            }
        }
    }

    private void doAddContent(File baseDir, String destSpaceId, File file) throws NotFoundException {
        String destContentId = this.getContentId(baseDir, file);
        InputStream stream = this.getInputStream(file);
        this.doAddContent(destSpaceId, destContentId, null, file.length(), stream);
    }

    private void doAddContent(String destSpaceId, String destContentId, String fileChecksum, long fileSize, InputStream stream) throws NotFoundException {
        long maxChunkSize = this.options.getMaxChunkSize();
        boolean ignoreLargeFiles = this.options.isIgnoreLargeFiles();
        boolean preserveChunkMD5s = this.options.isPreserveChunkMD5s();
        this.log.debug("loading file: " + destContentId + "[" + fileSize + "]");
        if (fileSize <= maxChunkSize) {
            BufferedInputStream buffStream = new BufferedInputStream(stream);
            ChunkInputStream chunk = new ChunkInputStream(destContentId, buffStream, fileSize, false);
            this.contentWriter.writeSingle(destSpaceId, fileChecksum, chunk);
        } else if (!ignoreLargeFiles) {
            String finalChecksum;
            ChunkableContent chunkable = new ChunkableContent(destContentId, stream, fileSize, maxChunkSize);
            chunkable.setPreserveChunkMD5s(preserveChunkMD5s);
            this.contentWriter.write(destSpaceId, chunkable);
            if (fileChecksum != null && !fileChecksum.equals(finalChecksum = chunkable.getManifest().getHeader().getSourceMD5())) {
                String err = "Final checksum of chunked content " + finalChecksum + " does not match provided checksum " + fileChecksum;
                throw new DuraCloudRuntimeException(err);
            }
        } else {
            this.log.info("Ignoring: [" + destContentId + "]");
            this.contentWriter.ignore(destSpaceId, destContentId, fileSize);
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private Collection<File> listFiles(File baseDir, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        if (!baseDir.isDirectory()) {
            throw new DuraCloudRuntimeException("Invalid dir: " + baseDir);
        }
        Collection files = FileUtils.listFiles((File)baseDir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        if (null == files || files.size() == 0) {
            throw new DuraCloudRuntimeException("No files found: " + baseDir);
        }
        return files;
    }

    private String getContentId(File baseDir, File file) {
        String basePath;
        String filePath = file.getPath();
        int index = filePath.indexOf(basePath = baseDir.getPath());
        if (index == -1) {
            StringBuilder sb = new StringBuilder("Invalid basePath for file: ");
            sb.append("b: '" + basePath + "', ");
            sb.append("f: '" + filePath + "'");
            throw new DuraCloudRuntimeException(sb.toString());
        }
        String contentId = filePath.substring(index + basePath.length());
        if (contentId.startsWith(File.separator)) {
            contentId = contentId.substring(1, contentId.length());
        }
        contentId = contentId.replaceAll("\\\\", "/");
        return contentId;
    }

    private InputStream getInputStream(File file) {
        try {
            return this.getInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new DuraCloudRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private InputStream getInputStream(InputStream stream) {
        return new AutoCloseInputStream(stream);
    }

    public static DigestInputStream createTestContent(File outFile, long size) throws IOException {
        int BUF_SZ = 8192;
        FileOutputStream fos = new FileOutputStream(outFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw, 8192);
        int MIN_CHAR = 32;
        int MAX_CHAR_MINUS_MIN_CHAR = 126 - MIN_CHAR;
        Random r = new Random();
        for (long i = 0L; i < size; ++i) {
            bw.write(r.nextInt(MAX_CHAR_MINUS_MIN_CHAR) + MIN_CHAR);
        }
        IOUtils.closeQuietly((Writer)bw);
        return ChecksumUtil.wrapStream((InputStream)new FileInputStream(outFile), (ChecksumUtil.Algorithm)ChecksumUtil.Algorithm.MD5);
    }
}

