/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.writer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.duracloud.chunk.ChunkableContent;
import org.duracloud.chunk.error.ContentNotAddedException;
import org.duracloud.chunk.error.NotFoundException;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.stream.ChunkInputStream;
import org.duracloud.chunk.stream.KnownLengthInputStream;
import org.duracloud.chunk.writer.AddContentResult;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudContentWriter
implements ContentWriter {
    private final Logger log = LoggerFactory.getLogger(DuracloudContentWriter.class);
    private ContentStore contentStore;
    private String username;
    private Set<String> existingSpaces = new HashSet<String>();
    private List<AddContentResult> results = new ArrayList<AddContentResult>();
    private boolean throwOnError = false;

    public DuracloudContentWriter(ContentStore contentStore, String username) {
        this.contentStore = contentStore;
        this.username = username;
    }

    public DuracloudContentWriter(ContentStore contentStore, String username, boolean throwOnError) {
        this(contentStore, username);
        this.throwOnError = throwOnError;
    }

    @Override
    public List<AddContentResult> getResults() {
        return this.results;
    }

    @Override
    public void ignore(String spaceId, String contentId, long contentSize) {
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        result.setState(AddContentResult.State.IGNORED);
        this.results.add(result);
    }

    @Override
    public ChunksManifest write(String spaceId, ChunkableContent chunkable) throws NotFoundException {
        this.log.debug("write: " + spaceId);
        this.createSpaceIfNotExist(spaceId);
        for (ChunkInputStream chunk : chunkable) {
            this.writeSingle(spaceId, null, chunk);
        }
        ChunksManifest manifest = chunkable.finalizeManifest();
        this.addManifest(spaceId, manifest);
        this.log.debug("written: " + spaceId + ", " + manifest.getManifestId());
        return manifest;
    }

    @Override
    public String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk) throws NotFoundException {
        this.log.debug("writeSingle: " + spaceId + ", " + chunk.getChunkId());
        this.createSpaceIfNotExist(spaceId);
        this.addChunk(spaceId, chunkChecksum, chunk);
        this.log.debug("written: " + spaceId + ", " + chunk.getChunkId());
        return chunk.getMD5();
    }

    private void addChunk(String spaceId, String chunkChecksum, ChunkInputStream chunk) {
        String chunkId = chunk.getChunkId();
        this.log.debug("addChunk: " + spaceId + ", " + chunkId);
        this.addContentThenReport(spaceId, chunkId, chunk, chunk.getChunkSize(), chunk.getMimetype(), chunkChecksum);
    }

    private void addManifest(String spaceId, ChunksManifest manifest) {
        String manifestId = manifest.getManifestId();
        this.log.debug("addManifest: " + spaceId + ", " + manifestId);
        KnownLengthInputStream manifestBody = manifest.getBody();
        this.addContentThenReport(spaceId, manifestId, manifestBody, manifestBody.getLength(), manifest.getMimetype(), null);
    }

    private void addContentThenReport(String spaceId, String contentId, InputStream contentStream, long contentSize, String contentMimetype, String contentChecksum) {
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        String md5 = null;
        try {
            md5 = this.addContent(spaceId, contentId, contentStream, contentSize, contentMimetype, contentChecksum);
        }
        catch (ContentNotAddedException e) {
            if (this.throwOnError) {
                String err = "Content not added due to: " + e.getMessage();
                throw new DuraCloudRuntimeException(err, (Throwable)((Object)e));
            }
            result.setState(AddContentResult.State.ERROR);
        }
        if (!this.throwOnError) {
            if (md5 != null) {
                result.setMd5(md5);
                result.setState(AddContentResult.State.SUCCESS);
            }
            this.results.add(result);
        }
    }

    private String addContent(String spaceId, String contentId, InputStream contentStream, long contentSize, String contentMimetype, String contentChecksum) throws ContentNotAddedException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("creator", this.username);
        try {
            return this.contentStore.addContent(spaceId, contentId, contentStream, contentSize, contentMimetype, contentChecksum, properties);
        }
        catch (ContentStoreException e) {
            this.log.error(e.getFormattedMessage(), (Throwable)e);
            throw new ContentNotAddedException(spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception ex) {
            this.log.error("Error adding content:" + ex.getMessage(), (Throwable)ex);
            throw new ContentNotAddedException(spaceId, contentId, ex);
        }
    }

    private void createSpaceIfNotExist(String spaceId) throws NotFoundException {
        boolean exists;
        if (this.existingSpaces.contains(spaceId)) {
            return;
        }
        if (!this.spaceExists(spaceId)) {
            this.createSpace(spaceId);
        }
        int tries = 0;
        while (!(exists = this.spaceExists(spaceId)) && tries++ < 10) {
            this.sleep(1000L);
        }
        if (!exists) {
            throw new NotFoundException("Space not found: " + spaceId);
        }
        this.existingSpaces.add(spaceId);
    }

    private void createSpace(String spaceId) {
        Map properties = null;
        try {
            this.contentStore.createSpace(spaceId, properties);
        }
        catch (ContentStoreException contentStoreException) {
            // empty catch block
        }
    }

    private boolean spaceExists(String spaceId) {
        try {
            return null != this.contentStore.getSpaceACLs(spaceId);
        }
        catch (ContentStoreException e) {
            return false;
        }
    }

    private void sleep(long napTime) {
        try {
            Thread.sleep(napTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

