/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.chunk.FileChunker;
import org.duracloud.chunk.FileChunkerOptions;
import org.duracloud.chunk.error.NotFoundException;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.chunk.writer.DuracloudContentWriter;
import org.duracloud.chunk.writer.FilesystemContentWriter;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.Credential;

public class FileChunkerDriver {
    private static void chunk(File fromDir, File toSpace, FileChunkerOptions options, ContentWriter writer) throws NotFoundException {
        if (!fromDir.isDirectory()) {
            throw new DuraCloudRuntimeException("Invalid dir: " + fromDir);
        }
        FileChunker chunker = new FileChunker(writer, options);
        chunker.addContentFrom(fromDir, toSpace.getPath());
        File report = new File("chunker-report.csv");
        chunker.writeReport(report);
        System.out.println("see report at: " + report.getAbsolutePath());
    }

    private static Long getChunkSize(String arg) {
        char unit = arg.toLowerCase().charAt(arg.length() - 1);
        if (unit != 'k' && unit != 'm' && unit != 'g') {
            throw new DuraCloudRuntimeException("Chunk size must be of the form: <digit(s)><K|M|G>");
        }
        int multiplier = Integer.parseInt(arg.substring(0, arg.length() - 1));
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        long chunkSize = 0x100000L;
        switch (unit) {
            case 'k': {
                chunkSize = (long)multiplier * 1024L;
                break;
            }
            case 'm': {
                chunkSize = (long)multiplier * 0x100000L;
                break;
            }
            case 'g': {
                chunkSize = (long)multiplier * 0x40000000L;
            }
        }
        return chunkSize;
    }

    private static Options getOptions() {
        Option username = new Option("u", "username", true, "username of duracloud instance");
        username.setArgs(1);
        username.setArgName("username");
        Option password = new Option("p", "password", true, "password of duracloud instance");
        password.setArgs(1);
        password.setArgName("password");
        Option create = new Option("g", "generate", true, "generate test data to <outFile> of <size> bytes");
        create.setArgs(2);
        create.setArgName("outFile numBytes");
        create.setValueSeparator(' ');
        Option add = new Option("a", "add", true, "add content from dir:<f> to space:<t> of max chunk size:<s> in units of K,M,G");
        add.setArgs(3);
        add.setArgName("f t s{K|M|G}");
        add.setValueSeparator(' ');
        Option fileFiltered = new Option("f", "file-filter", true, "limit processed files to those listed in file-list:<l>");
        fileFiltered.setArgs(1);
        fileFiltered.setArgName("l");
        Option dirFiltered = new Option("d", "dir-filter", true, "limit processed directories to those listed in file-list:<l>");
        dirFiltered.setArgs(1);
        dirFiltered.setArgName("l");
        Option cloud = new Option("c", "cloud-store", true, "use cloud store found at <host>:<port> as content dest");
        cloud.setArgs(2);
        cloud.setArgName("host:port");
        cloud.setValueSeparator(':');
        Option excludeChunkMD5s = new Option("x", "exclude-chunk-md5s", false, "if this option is set, chunk MD5s will NOT be preserved in the manifest");
        Option ignoreLargeFiles = new Option("i", "ignore-large-files", false, "if this option is set, files over the chunk size specified in the 'add' option will be ignored.");
        Options options = new Options();
        options.addOption(username);
        options.addOption(password);
        options.addOption(create);
        options.addOption(add);
        options.addOption(fileFiltered);
        options.addOption(dirFiltered);
        options.addOption(cloud);
        options.addOption(excludeChunkMD5s);
        options.addOption(ignoreLargeFiles);
        return options;
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(FileChunkerDriver.getOptions(), args);
        }
        catch (ParseException e) {
            System.err.println((Object)e);
            FileChunkerDriver.die();
        }
        return cmd;
    }

    private static void usage() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(80);
        help.printHelp(FileChunker.class.getCanonicalName(), FileChunkerDriver.getOptions());
    }

    private static void die() {
        FileChunkerDriver.usage();
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        ContentWriter writer;
        CommandLine cmd = FileChunkerDriver.parseArgs(args);
        FileChunkerDriver.ensureWritePermissionToLocalDir();
        Credential credential = null;
        String username = "";
        if (cmd.hasOption("username") || cmd.hasOption("password")) {
            username = cmd.getOptionValue("username");
            credential = FileChunkerDriver.getCredentials(username, cmd.getOptionValue("password"));
        }
        if (cmd.hasOption("cloud-store")) {
            String[] vals = cmd.getOptionValues("cloud-store");
            String host = vals[0];
            String port = vals[1];
            ContentStoreManagerImpl mgr = new ContentStoreManagerImpl(host, port);
            if (credential != null) {
                mgr.login(credential);
            }
            writer = new DuracloudContentWriter(mgr.getPrimaryContentStore(), username);
        } else {
            writer = new FilesystemContentWriter();
        }
        boolean chunkMD5 = true;
        if (cmd.hasOption("exclude-chunk-md5s")) {
            chunkMD5 = false;
        }
        boolean ignoreLarge = false;
        if (cmd.hasOption("ignore-large-files")) {
            ignoreLarge = true;
        }
        IOFileFilter fileFilter = TrueFileFilter.TRUE;
        if (cmd.hasOption("file-filter")) {
            String[] filterVals = cmd.getOptionValues("file-filter");
            fileFilter = FileChunkerDriver.buildFilter(new File(filterVals[0]));
        }
        IOFileFilter dirFilter = TrueFileFilter.TRUE;
        if (cmd.hasOption("dir-filter")) {
            String[] filterVals = cmd.getOptionValues("dir-filter");
            dirFilter = FileChunkerDriver.buildFilter(new File(filterVals[0]));
        }
        if (cmd.hasOption("add")) {
            String[] vals = cmd.getOptionValues("add");
            File fromDir = new File(vals[0]);
            File toDir = new File(vals[1]);
            Long chunkSize = FileChunkerDriver.getChunkSize(vals[2]);
            FileChunkerOptions options = new FileChunkerOptions(fileFilter, dirFilter, chunkSize, chunkMD5, ignoreLarge);
            FileChunkerDriver.chunk(fromDir, toDir, options, writer);
        } else if (cmd.hasOption("generate")) {
            String[] vals = cmd.getOptionValues("generate");
            File outFile = new File(vals[0]);
            long contentSize = Long.parseLong(vals[1]);
            FileChunker.createTestContent(outFile, contentSize);
        } else {
            FileChunkerDriver.usage();
        }
    }

    private static Credential getCredentials(String username, String password) {
        if (null == username || null == password) {
            String border = "**************\n";
            StringBuilder msg = new StringBuilder(border);
            msg.append("If either username or password are provided,\n");
            msg.append("they both must be provided.\n");
            msg.append(border);
            System.out.println(msg);
            FileChunkerDriver.die();
        }
        return new Credential(username, password);
    }

    private static void ensureWritePermissionToLocalDir() throws Exception {
        try {
            File tmp = new File("remove-me.txt");
            FileOutputStream fos = new FileOutputStream(tmp);
            fos.write("hello".getBytes());
            IOUtils.closeQuietly((OutputStream)fos);
            FileUtils.deleteQuietly((File)tmp);
        }
        catch (IOException e) {
            String border = "\n---------------------------------------------\n";
            StringBuilder sb = new StringBuilder(border);
            sb.append("User must have permissions to write to the current working directory.");
            sb.append(border);
            throw new Exception(sb.toString(), e);
        }
    }

    private static IOFileFilter buildFilter(File titlesFile) {
        ArrayList<NameFileFilter> filters = new ArrayList<NameFileFilter>();
        InputStream input = FileChunkerDriver.getInputStream(titlesFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        String line = FileChunkerDriver.readLine(br);
        while (line != null) {
            filters.add(new NameFileFilter(line.trim()));
            line = FileChunkerDriver.readLine(br);
        }
        IOUtils.closeQuietly((Reader)br);
        return new OrFileFilter(filters);
    }

    private static InputStream getInputStream(File file) {
        try {
            return new AutoCloseInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readLine(BufferedReader br) {
        try {
            return br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

