/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InventoryRetrievalJobInput;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InitiateJobRequestMarshaller
implements Marshaller<Request<InitiateJobRequest>, InitiateJobRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<InitiateJobRequest> marshall(InitiateJobRequest initiateJobRequest) {
        String value;
        String name;
        if (initiateJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateJobRequest> request = new DefaultRequest<InitiateJobRequest>(initiateJobRequest, "AmazonGlacier");
        String target = "Glacier.InitiateJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = initiateJobRequest.getAccountId() == null ? null : StringUtils.fromString(initiateJobRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", initiateJobRequest.getAccountId() == null ? "" : StringUtils.fromString(initiateJobRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = initiateJobRequest.getVaultName() == null ? null : StringUtils.fromString(initiateJobRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", initiateJobRequest.getVaultName() == null ? "" : StringUtils.fromString(initiateJobRequest.getVaultName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            JobParameters jobParameters = initiateJobRequest.getJobParameters();
            if (jobParameters != null) {
                InventoryRetrievalJobInput inventoryRetrievalParameters;
                jsonWriter.object();
                if (jobParameters.getFormat() != null) {
                    jsonWriter.key("Format").value(jobParameters.getFormat());
                }
                if (jobParameters.getType() != null) {
                    jsonWriter.key("Type").value(jobParameters.getType());
                }
                if (jobParameters.getArchiveId() != null) {
                    jsonWriter.key("ArchiveId").value(jobParameters.getArchiveId());
                }
                if (jobParameters.getDescription() != null) {
                    jsonWriter.key("Description").value(jobParameters.getDescription());
                }
                if (jobParameters.getSNSTopic() != null) {
                    jsonWriter.key("SNSTopic").value(jobParameters.getSNSTopic());
                }
                if (jobParameters.getRetrievalByteRange() != null) {
                    jsonWriter.key("RetrievalByteRange").value(jobParameters.getRetrievalByteRange());
                }
                if ((inventoryRetrievalParameters = jobParameters.getInventoryRetrievalParameters()) != null) {
                    jsonWriter.key("InventoryRetrievalParameters");
                    jsonWriter.object();
                    if (inventoryRetrievalParameters.getStartDate() != null) {
                        jsonWriter.key("StartDate").value(inventoryRetrievalParameters.getStartDate());
                    }
                    if (inventoryRetrievalParameters.getEndDate() != null) {
                        jsonWriter.key("EndDate").value(inventoryRetrievalParameters.getEndDate());
                    }
                    if (inventoryRetrievalParameters.getLimit() != null) {
                        jsonWriter.key("Limit").value(inventoryRetrievalParameters.getLimit());
                    }
                    if (inventoryRetrievalParameters.getMarker() != null) {
                        jsonWriter.key("Marker").value(inventoryRetrievalParameters.getMarker());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/jobs";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

