/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.stream;

import java.io.InputStream;
import java.security.DigestInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.duracloud.common.util.ChecksumUtil;

public class CountingDigestInputStream
extends CountingInputStream {
    private boolean preserveMD5;
    private String md5;

    public CountingDigestInputStream(InputStream inputStream, boolean preserveMD5) {
        super(CountingDigestInputStream.wrapStream(inputStream, preserveMD5));
        this.preserveMD5 = preserveMD5;
        this.md5 = null;
    }

    private static InputStream wrapStream(InputStream inputStream, boolean preserveMD5) {
        InputStream stream = inputStream;
        if (preserveMD5) {
            stream = ChecksumUtil.wrapStream((InputStream)inputStream, (ChecksumUtil.Algorithm)ChecksumUtil.Algorithm.MD5);
        }
        return stream;
    }

    public String getMD5() {
        if (!this.preserveMD5) {
            this.md5 = "MD5-not-preserved";
        } else if (null == this.md5) {
            this.md5 = ChecksumUtil.getChecksum((DigestInputStream)((DigestInputStream)this.in));
        }
        return this.md5;
    }
}

