/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtil {
    private final Logger log = LoggerFactory.getLogger(ChecksumUtil.class);
    private final MessageDigest digest;

    public ChecksumUtil(Algorithm alg) {
        try {
            this.digest = MessageDigest.getInstance(alg.toString());
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Error getting msg digest instance", e);
            throw new RuntimeException(e);
        }
    }

    public String generateChecksum(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            String string = this.generateChecksum(stream);
            return string;
        }
    }

    public String generateChecksum(InputStream inStream) {
        byte[] buf = new byte[4096];
        int numRead = 0;
        long totalBytesRead = 0L;
        while ((numRead = this.readFromStream(inStream, buf)) != -1) {
            this.digest.update(buf, 0, numRead);
            if (!this.log.isDebugEnabled() || (totalBytesRead += (long)numRead) % 1000000000L != 0L) continue;
            this.log.debug("Total bytes read: {}", (Object)totalBytesRead);
        }
        return ChecksumUtil.checksumBytesToString(this.digest.digest());
    }

    public String generateChecksum(String string) {
        return ChecksumUtil.checksumBytesToString(this.generateChecksumBytes(string));
    }

    private byte[] generateChecksumBytes(String string) {
        try {
            this.digest.update(string.getBytes("UTF-8"));
            return this.digest.digest();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateChecksumBase64(String string) {
        return new String(Base64.encodeBase64(this.generateChecksumBytes(string)));
    }

    private int readFromStream(InputStream inStream, byte[] buf) {
        int numRead = -1;
        try {
            numRead = inStream.read(buf);
        }
        catch (IOException e) {
            this.log.error("Error reading stream", e);
            throw new RuntimeException(e);
        }
        return numRead;
    }

    public static DigestInputStream wrapStream(InputStream inStream, Algorithm algorithm) {
        MessageDigest streamDigest = null;
        try {
            streamDigest = MessageDigest.getInstance(algorithm.toString());
        }
        catch (NoSuchAlgorithmException e) {
            String error = "Could not create a MessageDigest because the required algorithm " + algorithm.toString() + " is not supported.";
            throw new RuntimeException(error);
        }
        DigestInputStream wrappedContent = new DigestInputStream(inStream, streamDigest);
        return wrappedContent;
    }

    public static String getChecksum(DigestInputStream digestStream) {
        MessageDigest digest = digestStream.getMessageDigest();
        return ChecksumUtil.checksumBytesToString(digest.digest());
    }

    public static byte[] getChecksumBytes(DigestInputStream digestStream) {
        MessageDigest digest = digestStream.getMessageDigest();
        return digest.digest();
    }

    public static String checksumBytesToString(byte[] digestBytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digestBytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & digestBytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }

    public static String convertToBase64Encoding(String hexEncodedChecksum) {
        byte[] checksumBytes = ChecksumUtil.hexStringToByteArray(hexEncodedChecksum);
        return new String(Base64.encodeBase64(checksumBytes));
    }

    public static enum Algorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA_1("SHA-1"),
        SHA_256("SHA-256"),
        SHA_384("SHA-384"),
        SHA_512("SHA-512");

        private final String text;

        private Algorithm(String input) {
            this.text = input;
        }

        public static Algorithm fromString(String input) {
            for (Algorithm alg : Algorithm.values()) {
                if (!alg.text.equalsIgnoreCase(input)) continue;
                return alg;
            }
            return MD5;
        }

        public String toString() {
            return this.text;
        }
    }
}

