/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.util;

import com.amazonaws.util.CollectionUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunksManifestVerifier {
    private static final Logger log = LoggerFactory.getLogger(ChunksManifestVerifier.class);
    private ContentStore contentStore;

    public ChunksManifestVerifier(ContentStore contentStore) {
        assert (contentStore != null);
        this.contentStore = contentStore;
    }

    public Results verifyAllChunks(String spaceId, ChunksManifest manifest) {
        Results results = new Results();
        for (ChunksManifestBean.ManifestEntry entry : manifest.getEntries()) {
            String chunkId = entry.getChunkId();
            String checksum = entry.getChunkMD5();
            long byteSize = entry.getByteSize();
            try {
                Map props = this.contentStore.getContentProperties(spaceId, entry.getChunkId());
                String remoteChecksum = (String)props.get("content-checksum");
                long remoteByteSize = Long.valueOf((String)props.get("content-size"));
                if (!checksum.equals(remoteChecksum)) {
                    results.add(chunkId, "manifest checksum (" + checksum + ") does not match DuraCloud checksum (" + remoteChecksum + ")", false);
                    continue;
                }
                if (byteSize != remoteByteSize) {
                    results.add(chunkId, "manifest byte size (" + byteSize + ") does not match DuraCloud byte size (" + remoteByteSize + ")", false);
                    continue;
                }
                results.add(chunkId, null, true);
            }
            catch (Exception ex) {
                results.add(chunkId, ex.getMessage(), false);
            }
        }
        if (CollectionUtils.isNullOrEmpty(results.get())) {
            throw new DuraCloudRuntimeException("failed to retrieve any chunks at list in chunk manifest:  " + spaceId + "/" + manifest.getManifestId());
        }
        return results;
    }

    public static final class Result {
        private String chunkId;
        private String error;
        private boolean success;

        private Result(String chunkId, String error, boolean success) {
            this.chunkId = chunkId;
            this.error = error;
            this.success = success;
        }

        public String getChunkId() {
            return this.chunkId;
        }

        public String getError() {
            return this.error;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    public static final class Results {
        private List<Result> resultList = null;

        private Results() {
        }

        public boolean isSuccess() {
            if (!CollectionUtils.isNullOrEmpty(this.resultList)) {
                for (Result r : this.resultList) {
                    if (r.isSuccess()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void add(String chunkId, String error, boolean success) {
            if (this.resultList == null) {
                this.resultList = new LinkedList<Result>();
            }
            this.resultList.add(new Result(chunkId, error, success));
            if (success) {
                log.debug("chunk successfully verified: {}", (Object)chunkId);
            } else {
                log.warn("unable to verify chunk {} due to : {}", (Object)chunkId, (Object)error);
            }
        }

        public List<Result> get() {
            return this.resultList;
        }
    }
}

