/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.common.error.RetryFlaggableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class RetryAdvice
implements MethodInterceptor,
Ordered {
    private final Logger log = LoggerFactory.getLogger(RetryAdvice.class);
    private int maxRetries;
    private int waitTime;
    private int order;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int numAttempts = 0;
        while (true) {
            ++numAttempts;
            try {
                return invocation.proceed();
            }
            catch (RetryFlaggableException se) {
                if (se.isRetry()) {
                    if (numAttempts <= this.maxRetries) {
                        this.logRetry(invocation, se.getMessage());
                        Thread.sleep(this.waitTime);
                        continue;
                    }
                    this.logRetriesExceeded(invocation, se.getMessage());
                    throw se;
                }
                throw se;
            }
            break;
        }
    }

    private void logRetry(MethodInvocation invocation, String errorMsg) {
        if (this.log.isDebugEnabled()) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Caught StorageException (");
            logMsg.append(errorMsg);
            logMsg.append(") when attempting to call ");
            logMsg.append(invocation.getMethod());
            logMsg.append(" with arguments [");
            logMsg.append(this.buildMethodArgs(invocation));
            logMsg.append("] Retrying call.");
            this.log.debug(logMsg.toString());
        }
    }

    private void logRetriesExceeded(MethodInvocation invocation, String errorMsg) {
        if (this.log.isDebugEnabled()) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Caught StorageException (");
            logMsg.append(errorMsg);
            logMsg.append(") when attempting to call ");
            logMsg.append(invocation.getMethod());
            logMsg.append(" with arguments [");
            logMsg.append(this.buildMethodArgs(invocation));
            logMsg.append("] Max retries exceeded, throwing.");
            this.log.debug(logMsg.toString());
        }
    }

    private String buildMethodArgs(MethodInvocation invocation) {
        StringBuilder methodArgs = new StringBuilder();
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument != null) {
                methodArgs.append(argument.toString());
            } else {
                methodArgs.append("null");
            }
            if (i >= arguments.length - 1) continue;
            methodArgs.append(", ");
        }
        return methodArgs.toString();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

