/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.changenotifier.impl;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.repo.GlobalPropertiesRepo;
import org.duracloud.common.changenotifier.AccountChangeNotifier;
import org.duracloud.common.changenotifier.NotifierType;
import org.duracloud.common.event.AccountChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="accountChangeNotifier")
public class AccountChangeNotifierImpl
implements AccountChangeNotifier {
    private AmazonSNS snsClient;
    private Channel rabbitMqChannel;
    private String rabbitmqExchange;
    private String rabbitmqVhost;
    private NotifierType notifierType;
    private GlobalPropertiesRepo globalPropertiesRepo;
    private static Logger log = LoggerFactory.getLogger(AccountChangeNotifierImpl.class);

    @Autowired
    public AccountChangeNotifierImpl(GlobalPropertiesRepo globalPropertiesRepo) {
        this.globalPropertiesRepo = globalPropertiesRepo;
        GlobalProperties props = null;
        try {
            props = (GlobalProperties)globalPropertiesRepo.findAll().get(0);
            this.notifierType = NotifierType.fromString(props.getNotifierType());
        }
        catch (Exception e) {
            this.notifierType = NotifierType.SNS;
        }
        log.info("Notifier-Type: {}", (Object)this.notifierType.toString());
        if (this.notifierType == NotifierType.RABBITMQ) {
            this.rabbitmqExchange = props.getRabbitmqExchange();
            this.rabbitmqVhost = props.getRabbitmqVhost();
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(props.getRabbitmqUsername());
            factory.setPassword(props.getRabbitmqPassword());
            factory.setVirtualHost(this.rabbitmqVhost);
            factory.setHost(props.getRabbitmqHost());
            factory.setPort(props.getRabbitmqPort().intValue());
            log.info("RabbitMQ Host: {}, Vhost: {}, Exchange: {}", new Object[]{props.getRabbitmqHost(), this.rabbitmqVhost, this.rabbitmqExchange});
            try {
                Connection conn = factory.newConnection();
                this.rabbitMqChannel = conn.createChannel();
            }
            catch (Exception e) {
                log.error("Failed to connect to RabbitMQ because: " + e.getMessage(), (Throwable)e);
            }
        } else {
            log.info("Initiate default SNS client");
            try {
                this.snsClient = AmazonSNSClientBuilder.defaultClient();
            }
            catch (Exception e) {
                log.error("Failed to initiate SNS client because: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void accountChanged(String account) {
        this.publish(AccountChangeEvent.EventType.ACCOUNT_CHANGED, account);
    }

    private void publish(AccountChangeEvent.EventType eventType, String account) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("unable to resolve unknown host: " + e.getMessage(), (Throwable)e);
            host = "unknown";
        }
        AccountChangeEvent event = new AccountChangeEvent(eventType, account, host);
        try {
            log.debug("publishing event={}", (Object)event);
            if (this.notifierType == NotifierType.RABBITMQ) {
                this.rabbitMqChannel.basicPublish(this.rabbitmqExchange, "", null, AccountChangeEvent.serialize((AccountChangeEvent)event).getBytes());
                log.info("published event via RabbitMQ, vhost={}, exchange={}, event={}", new Object[]{this.rabbitmqVhost, this.rabbitmqExchange, event});
            } else {
                GlobalProperties props = (GlobalProperties)this.globalPropertiesRepo.findAll().get(0);
                this.snsClient.publish(props.getInstanceNotificationTopicArn(), AccountChangeEvent.serialize((AccountChangeEvent)event));
                log.info("published event via SNS, event={}", (Object)event);
            }
        }
        catch (Exception e) {
            log.error("Failed to publish event: " + event + " : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void storageProvidersChanged(String accountId) {
        this.publish(AccountChangeEvent.EventType.STORAGE_PROVIDERS_CHANGED, accountId);
    }

    @Override
    public void userStoreChanged(String accountId) {
        this.publish(AccountChangeEvent.EventType.USERS_CHANGED, accountId);
    }

    @Override
    public void rootUsersChanged() {
        this.publish(AccountChangeEvent.EventType.ALL_ACCOUNTS_CHANGED, null);
    }

    @Override
    public void storageProviderCacheOnNodeChanged(String account) {
        this.publish(AccountChangeEvent.EventType.STORAGE_PROVIDER_CACHE_ON_NODE_CHANGED, account);
    }
}

