/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.changenotifier.config;

import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.Message;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.repo.GlobalPropertiesRepo;
import org.duracloud.common.cache.AccountComponentCache;
import org.duracloud.common.changenotifier.MessageListener;
import org.duracloud.common.changenotifier.NotifierType;
import org.duracloud.common.changenotifier.RabbitMQSubscriptionManager;
import org.duracloud.common.changenotifier.SnsSubscriptionManager;
import org.duracloud.common.changenotifier.SubscriptionManager;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.event.AccountChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SubscriptionManagerConfig {
    private Logger log = LoggerFactory.getLogger(SubscriptionManagerConfig.class);

    @Bean(destroyMethod="disconnect", initMethod="connect")
    public SubscriptionManager subscriptionManager(GlobalPropertiesRepo globalPropertiesRepo, final List<AccountComponentCache<?>> componentCaches, String appName) {
        try {
            GlobalProperties props = (GlobalProperties)globalPropertiesRepo.findAll().get(0);
            String queueName = "node-queue-" + appName + "-" + Inet4Address.getLocalHost().getHostName().replace(".", "_");
            NotifierType notifierType = NotifierType.fromString(props.getNotifierType());
            SubscriptionManager subscriptionManager = notifierType == NotifierType.RABBITMQ ? new RabbitMQSubscriptionManager(props.getRabbitmqHost(), props.getRabbitmqPort(), props.getRabbitmqVhost(), props.getRabbitmqExchange(), props.getRabbitmqUsername(), props.getRabbitmqPassword(), queueName) : new SnsSubscriptionManager(AmazonSQSClientBuilder.defaultClient(), AmazonSNSClientBuilder.defaultClient(), props.getInstanceNotificationTopicArn(), queueName);
            subscriptionManager.addListener(new MessageListener(){

                @Override
                public void onMessage(Message message) {
                    SubscriptionManagerConfig.this.log.info("message received: " + message);
                    SubscriptionManagerConfig.this.log.debug("message body: " + message.getBody());
                    JsonFactory factory = new JsonFactory();
                    ObjectMapper mapper = new ObjectMapper(factory);
                    TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                    String body = message.getBody();
                    try {
                        Map map = (Map)mapper.readValue(body, (TypeReference)typeRef);
                        AccountChangeEvent event = AccountChangeEvent.deserialize((String)((String)map.get("Message")));
                        for (AccountComponentCache cache : componentCaches) {
                            cache.onEvent(event);
                        }
                    }
                    catch (IOException e) {
                        SubscriptionManagerConfig.this.log.warn("unable to dispatch message: " + message + " : " + e.getMessage(), (Throwable)e);
                    }
                }

                @Override
                public void onMessage(String message) {
                    SubscriptionManagerConfig.this.log.info("message received: " + message);
                    try {
                        AccountChangeEvent event = AccountChangeEvent.deserialize((String)message);
                        for (AccountComponentCache cache : componentCaches) {
                            cache.onEvent(event);
                        }
                    }
                    catch (Exception e) {
                        SubscriptionManagerConfig.this.log.warn("unable to dispatch message: " + message + " : " + e.getMessage(), (Throwable)e);
                    }
                }
            });
            return subscriptionManager;
        }
        catch (UnknownHostException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }
}

