/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.model.SimpleCredential;
import org.duracloud.common.test.StorageProviderCredential;
import org.duracloud.common.test.TestConfig;

public class TestConfigUtil {
    public static final String DURACLOUD_TEST_CONFIG = "DURACLOUD-TEST-CONFIG";

    public TestConfig getTestConfig() throws IOException {
        String testConfigPath = System.getenv().get(DURACLOUD_TEST_CONFIG);
        String jsonTestConfig = FileUtils.readFileToString((File)new File(testConfigPath));
        JaxbJsonSerializer<TestConfig> serializer = new JaxbJsonSerializer<TestConfig>(TestConfig.class);
        return serializer.deserialize(jsonTestConfig);
    }

    public SimpleCredential getCredential(StorageProviderCredential.ProviderType type) throws IOException {
        TestConfig config = this.getTestConfig();
        for (StorageProviderCredential cred : config.getProviderCredentials()) {
            if (!cred.getType().equals((Object)type)) continue;
            return cred.getCredential();
        }
        throw new IOException("No credential available for type: " + type.name());
    }
}

