/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.json;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JaxbJsonSerializer<T> {
    private Class type;
    private ObjectMapper mapper;

    public JaxbJsonSerializer(Class<T> type) {
        this.type = type;
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().withInsertedAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().withInsertedAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public String serialize(T object) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, object);
        return writer.toString();
    }

    public T deserialize(String json) throws IOException {
        return (T)this.mapper.readValue(json, this.type);
    }
}

