/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.queue.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Task {
    public static final String KEY_TYPE = "type";
    private Type type;
    private Map<String, String> properties = new HashMap<String, String>();
    private Integer visibilityTimeout;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public Integer getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public int getAttempts() {
        String attempts = this.properties.get("attempts");
        if (attempts == null) {
            attempts = "0";
        }
        return Integer.parseInt(attempts);
    }

    public void incrementAttempts() {
        int attempts = this.getAttempts() + 1;
        this.properties.put("attempts", attempts + "");
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum Type {
        BIT,
        BIT_REPORT,
        BIT_ERROR,
        DUP,
        AUDIT,
        STORAGE_STATS,
        NOOP;

    }
}

