/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.common.util.AccountIdUtil;

public class DuraCloudRequestContextFilter
implements Filter {
    static final String X_FORWARDED_HOST_HEADER = "X-FORWARDED-HOST";
    static final String ACCOUNT_ID_OVERRIDE_SYSTEM_PROP_KEY = "org.duracloud.account.id";
    private String accountIdOverride = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.accountIdOverride = System.getProperty(ACCOUNT_ID_OVERRIDE_SYSTEM_PROP_KEY);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String accountId = this.accountIdOverride;
        String host = httpRequest.getHeader(X_FORWARDED_HOST_HEADER);
        if (host == null) {
            host = request.getServerName();
        }
        if (accountId == null) {
            accountId = AccountIdUtil.extractAccountIdFromHost((String)host);
        }
        httpRequest.setAttribute(ACCOUNT_ID_OVERRIDE_SYSTEM_PROP_KEY, (Object)accountId);
        httpRequest.setAttribute("org.duracloud.request.host", (Object)host);
        httpRequest.setAttribute("org.duracloud.request.port", (Object)httpRequest.getServerPort());
        chain.doFilter(request, response);
    }
}

