/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.rest;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.duracloud.common.rest.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtilImpl
implements RestUtil {
    protected final Logger log = LoggerFactory.getLogger(RestUtilImpl.class);

    @Override
    public RestUtil.RequestContent getRequestContent(HttpServletRequest request, HttpHeaders headers) throws Exception {
        RestUtil.RequestContent rContent = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                String contentLength;
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                rContent = new RestUtil.RequestContent();
                rContent.contentStream = item.openStream();
                rContent.mimeType = item.getContentType();
                FileItemHeaders itemHeaders = item.getHeaders();
                if (itemHeaders != null && (contentLength = itemHeaders.getHeader("Content-Length")) != null) {
                    rContent.size = Long.parseLong(contentLength);
                }
                break;
            }
        } else {
            rContent = new RestUtil.RequestContent();
            rContent.contentStream = request.getInputStream();
            if (request.getContentLength() >= 0) {
                rContent.size = request.getContentLength();
            }
        }
        if (rContent != null) {
            List lengthHeaders;
            MediaType mediaType;
            if (rContent.mimeType == null && (mediaType = headers.getMediaType()) != null) {
                rContent.mimeType = mediaType.toString();
            }
            if (rContent.size == 0L && (lengthHeaders = headers.getRequestHeader("Content-Length")) != null && lengthHeaders.size() > 0) {
                rContent.size = Long.parseLong((String)lengthHeaders.get(0));
            }
        }
        return rContent;
    }
}

