/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static Date convertToDate(String text, DateFormat format) throws ParseException {
        SimpleDateFormat dateFormat = format.format;
        dateFormat.setLenient(false);
        Date date = dateFormat.parse(text);
        return date;
    }

    public static Date convertToDate(String text) throws ParseException {
        return DateUtil.convertToDate(text, DateFormat.DEFAULT_FORMAT);
    }

    public static String now() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.DEFAULT_FORMAT);
    }

    public static String nowLong() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.LONG_FORMAT);
    }

    public static String nowMid() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.MID_FORMAT);
    }

    public static String nowShort() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.SHORT_FORMAT);
    }

    public static String nowVerbose() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.VERBOSE_FORMAT);
    }

    public static String nowPlain() {
        long now = System.currentTimeMillis();
        return DateUtil.convertToString(now, DateFormat.PLAIN_FORMAT);
    }

    public static String convertToString(long millis, DateFormat format) {
        SimpleDateFormat dateFormat = format.format;
        return dateFormat.format(millis);
    }

    public static String convertToString(long millis) {
        return DateUtil.convertToString(millis, DateFormat.DEFAULT_FORMAT);
    }

    public static String convertToStringLong(long millis) {
        return DateUtil.convertToString(millis, DateFormat.LONG_FORMAT);
    }

    public static String convertToStringMid(long millis) {
        return DateUtil.convertToString(millis, DateFormat.MID_FORMAT);
    }

    public static String convertToStringShort(long millis) {
        return DateUtil.convertToString(millis, DateFormat.SHORT_FORMAT);
    }

    public static String convertToStringVerbose(long millis) {
        return DateUtil.convertToString(millis, DateFormat.VERBOSE_FORMAT);
    }

    public static String convertToStringPlain(long millis) {
        return DateUtil.convertToString(millis, DateFormat.PLAIN_FORMAT);
    }

    public static String convertToStringYearMonth(long millis) {
        return DateUtil.convertToString(millis, DateFormat.YEAR_MONTH_FORMAT);
    }

    public static enum DateFormat {
        LONG_FORMAT("yyyy-MM-dd'T'HH:mm:ss.sss"),
        DEFAULT_FORMAT("yyyy-MM-dd'T'HH:mm:ss"),
        MID_FORMAT("yyyy-MM-dd'T'HH:mm"),
        SHORT_FORMAT("yyyy-MM-dd"),
        YEAR_MONTH_FORMAT("yyyy-MM"),
        VERBOSE_FORMAT("EEE, d MMM yyyy HH:mm:ss z"),
        PLAIN_FORMAT("yyyy-MM-dd-HH-mm-ss");

        private final SimpleDateFormat format;

        private DateFormat(String pattern) {
            this.format = new SimpleDateFormat(pattern);
        }

        public String getPattern() {
            return this.format.toPattern();
        }
    }
}

