/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.retry;

import org.duracloud.common.retry.ExceptionHandler;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.util.WaitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier {
    public static final int DEFAULT_MAX_RETRIES = 3;
    private int maxRetries;
    private static final Logger log = LoggerFactory.getLogger(Retrier.class);
    private static final ExceptionHandler DEFAULT_EXCEPTION_HANDLER = new ExceptionHandler(){

        @Override
        public void handle(Exception ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
        }
    };

    public Retrier() {
        this.maxRetries = 3;
    }

    public Retrier(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public <T> T execute(Retriable retriable) throws Exception {
        return this.execute(retriable, DEFAULT_EXCEPTION_HANDLER);
    }

    public <T> T execute(Retriable retriable, ExceptionHandler exceptionHandler) throws Exception {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exceptionHandler must be non-null");
        }
        Exception lastException = null;
        for (int i = 0; i <= this.maxRetries; ++i) {
            try {
                return (T)retriable.retry();
            }
            catch (Exception e) {
                lastException = e;
                exceptionHandler.handle(e);
                WaitUtil.wait(i);
                continue;
            }
        }
        throw lastException;
    }
}

