/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class DuracloudConfigBean {
    protected Environment env;

    public DuracloudConfigBean(Environment env) {
        this.env = env;
    }

    public String getMcHost() {
        return this.env.getProperty("mc.host");
    }

    public String getMcPort() {
        return this.env.getProperty("mc.port");
    }

    public String getMcContext() {
        return this.env.getProperty("mc.context");
    }

    public String getAmaUrl() {
        String port = this.getMcPort();
        String context = this.getMcContext();
        String amaUrl = new String();
        switch (port) {
            case "80": {
                amaUrl = "http://" + this.getMcHost();
                break;
            }
            case "443": {
                amaUrl = "https://" + this.getMcHost();
                break;
            }
            default: {
                amaUrl = "http://" + this.getMcHost() + ":" + port;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)context)) {
            amaUrl = amaUrl + "/" + context;
        }
        return amaUrl;
    }

    public String getSwiftAccessKey() {
        return this.env.getProperty("swift.accessKey");
    }

    public String getSwiftSecretKey() {
        return this.env.getProperty("swift.secretKey");
    }

    public String getSwiftEndpoint() {
        return this.env.getProperty("swift.endpoint");
    }

    public String getSwiftSignerType() {
        String signer = this.env.getProperty("swift.signerType");
        if (signer.isEmpty()) {
            return null;
        }
        return signer;
    }
}

