/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.common.error.DuraCloudRuntimeException;

public class IOUtil {
    private static final int COPY_BUFFER_SIZE = 4096;

    private IOUtil() {
    }

    public static String readStringFromStream(InputStream stream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (String)"UTF-8");
        stream.close();
        return writer.toString();
    }

    public static InputStream writeStringToStream(String string) throws IOException {
        return IOUtils.toInputStream((String)string, (String)"UTF-8");
    }

    public static OutputStream getOutputStream(File file) {
        FileOutputStream output;
        try {
            output = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DuraCloudRuntimeException(e);
        }
        return output;
    }

    public static void copy(InputStream input, OutputStream output) {
        try {
            IOUtils.copy((InputStream)input, (OutputStream)output, (int)4096);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    public static void copyFileToDirectory(File file, File dir) {
        try {
            FileUtils.copyFileToDirectory((File)file, (File)dir);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    public static void fileFindReplace(File file, String find, String replace) throws IOException {
        String fileContents = FileUtils.readFileToString((File)file);
        fileContents = fileContents.replaceAll("\\Q" + find + "\\E", replace);
        FileUtils.writeStringToFile((File)file, (String)fileContents);
    }

    public static File writeStreamToFile(InputStream inStream) {
        return IOUtil.writeStreamToFile(inStream, false);
    }

    public static File writeStreamToFile(InputStream inStream, boolean gzip) {
        File file = null;
        OutputStream outStream = null;
        try {
            file = File.createTempFile("file", ".tmp");
            outStream = FileUtils.openOutputStream((File)file);
            if (gzip) {
                outStream = new GZIPOutputStream(outStream);
            }
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream, (int)4096);
        }
        catch (IOException e) {
            String err = "Error writing stream to file: " + e.getMessage();
            if (null != outStream) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            if (file != null && file.exists()) {
                file.delete();
            }
            throw new DuraCloudRuntimeException(err, e);
        }
        finally {
            if (null != inStream) {
                IOUtils.closeQuietly((InputStream)inStream);
            }
            if (null != outStream) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
        }
        return file;
    }

    public static InputStream getFileStream(File file) {
        try {
            return new AutoCloseInputStream((InputStream)FileUtils.openInputStream((File)file));
        }
        catch (IOException e) {
            String err = "Error opening stream from file " + file.getAbsolutePath() + ": " + e.getMessage();
            throw new DuraCloudRuntimeException(err, e);
        }
    }

    public static void addFileToZipOutputStream(File file, ZipOutputStream zipOs) throws IOException {
        String fileName = file.getName();
        try (FileInputStream fos = new FileInputStream(file);){
            int bytesRead;
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipEntry.setSize(file.length());
            zipEntry.setTime(System.currentTimeMillis());
            zipOs.putNextEntry(zipEntry);
            byte[] buf = new byte[1024];
            while ((bytesRead = fos.read(buf)) > 0) {
                zipOs.write(buf, 0, bytesRead);
            }
            zipOs.closeEntry();
            fos.close();
        }
    }
}

