/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.computeprovider.mgmt;

import java.util.Map;
import org.duracloud.computeprovider.domain.ComputeProviderType;
import org.duracloud.computeprovider.mgmt.ComputeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeProviderFactory {
    protected static final Logger log = LoggerFactory.getLogger(ComputeProviderFactory.class);
    private static Map<String, String> typeToClassMap;

    public static ComputeProvider getComputeProvider(ComputeProviderType providerType) throws Exception {
        ComputeProvider provider = null;
        Exception exception = null;
        String className = ComputeProviderFactory.getClassNameFromId(providerType);
        log.debug("class for id: '" + (Object)((Object)providerType) + "' : '" + className + "'");
        Class<?> clazz = ComputeProviderFactory.getClass(className, exception);
        if (clazz != null) {
            provider = ComputeProviderFactory.getInstance(clazz, exception);
        }
        if (provider == null) {
            throw exception;
        }
        return provider;
    }

    private static String getClassNameFromId(ComputeProviderType providerType) throws Exception {
        String className = null;
        try {
            className = typeToClassMap.get(providerType.toString());
        }
        catch (Exception e) {
            log.error("Error retrieving from map", (Throwable)e);
            throw e;
        }
        return className;
    }

    private static Class<?> getClass(String className, Exception exception) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("No class found for classname: '" + className + "'", (Throwable)e);
            exception = e;
        }
        return clazz;
    }

    private static ComputeProvider getInstance(Class<?> clazz, Exception exception) {
        ComputeProvider provider = null;
        try {
            provider = (ComputeProvider)clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Error with instantiation", (Throwable)e);
            exception = e;
        }
        catch (IllegalAccessException e) {
            log.error("Illegal access", (Throwable)e);
            exception = e;
        }
        return provider;
    }

    public Map<String, String> getIdToClassMap() {
        return typeToClassMap;
    }

    public static void setIdToClassMap(Map<String, String> map) {
        typeToClassMap = map;
    }
}

