/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.computeprovider.mgmt.mock;

import java.net.URL;
import org.duracloud.common.model.Credential;
import org.duracloud.computeprovider.mgmt.ComputeProvider;
import org.duracloud.computeprovider.mgmt.InstanceDescription;
import org.duracloud.computeprovider.mgmt.mock.MockInstanceDescription;

public class LocalComputeProviderImpl
implements ComputeProvider {
    private final String instanceId = "mockInstanceId";
    private final String url = "http://localhost:8080/instancewebapp";

    @Override
    public InstanceDescription describeRunningInstance(Credential credential, String instanceId, String xmlProps) {
        return new MockInstanceDescription();
    }

    @Override
    public URL getWebappURL(Credential credential, String instanceId, String xmlProps) throws Exception {
        if (!this.isInstanceRunning(credential, instanceId, xmlProps)) {
            throw new Exception("Mock web app is not running: no url!");
        }
        return new URL("http://localhost:8080/instancewebapp");
    }

    @Override
    public boolean isInstanceBooting(Credential credential, String instanceId, String xmlProps) throws Exception {
        return false;
    }

    @Override
    public boolean isInstanceRunning(Credential credential, String instanceId, String xmlProps) throws Exception {
        return this.instanceId.equals(instanceId);
    }

    @Override
    public boolean isWebappRunning(Credential credential, String instanceId, String xmlProps) throws Exception {
        return this.instanceId.equals(instanceId);
    }

    @Override
    public String start(Credential cred, String xmlProps) throws Exception {
        return "mockInstanceId";
    }

    @Override
    public void stop(Credential credential, String instanceId, String xmlProps) throws Exception {
    }
}

