/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.collection.jpa;

import java.util.Collection;
import org.duracloud.common.collection.IteratorSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class JpaIteratorSource<R, T>
implements IteratorSource<T> {
    private int currentPage = 0;
    private int maxResults;
    private R repo;

    public JpaIteratorSource(R repo, int maxResults) {
        this.repo = repo;
        if (maxResults <= 0) {
            throw new IllegalArgumentException("maxResults must be greater than 0");
        }
        this.maxResults = maxResults;
    }

    public JpaIteratorSource(R repo) {
        this(repo, 1000);
    }

    @Override
    public Collection<T> getNext() {
        if (this.currentPage < 0) {
            return null;
        }
        Page<T> page = this.getNextPage((Pageable)PageRequest.of((int)this.currentPage, (int)this.maxResults), this.repo);
        ++this.currentPage;
        if (page.getTotalPages() == this.currentPage) {
            this.currentPage = -1;
        }
        return page.getContent();
    }

    protected abstract Page<T> getNextPage(Pageable var1, R var2);

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }
}

