/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.repo;

import java.text.MessageFormat;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.manifest.jpa.JpaManifestStore;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.mill"}, entityManagerFactoryRef="millRepoEntityManagerFactory", transactionManagerRef="millJpaRepoTransactionManager")
@EnableTransactionManagement
public class MillJpaRepoConfig {
    private static final String MILL_REPO_ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";
    public static final String MILL_REPO_DATA_SOURCE_BEAN = "millRepoDataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "millJpaRepoTransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";
    @Value(value="${mill.db.host ?:localhost}")
    private String host;
    @Value(value="${mill.db.port ?: 3306}")
    private int port;
    @Value(value="${mill.db.name ?: mill}")
    private String name;
    @Value(value="${mill.db.user ?: user}")
    private String user;
    @Value(value="${mill.db.pass ?: pass}")
    private String pass;
    @Value(value="${hibernate.show_sql ?: false}")
    private String showSql;
    @Value(value="${hibernate.hbm2ddl.auto ?: validate}")
    private String hbm2ddlAuto;

    @Bean(name={"millRepoDataSource"}, destroyMethod="close")
    public BasicDataSource millRepoDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}?characterEncoding=utf8&characterSetResults=utf8", this.host, this.port, this.name));
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.pass);
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    @Bean(name={"millJpaRepoTransactionManager"})
    public PlatformTransactionManager millRepoTransactionManager(@Qualifier(value="millRepoEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"millRepoEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean millRepoEntityManagerFactory(@Qualifier(value="millRepoDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("mill-repo-pu");
        emf.setPackagesToScan(new String[]{"org.duracloud.mill"});
        HibernateJpaVendorAdapter va = new HibernateJpaVendorAdapter();
        va.setGenerateDdl(this.hbm2ddlAuto != null);
        va.setDatabase(Database.MYSQL);
        emf.setJpaVendorAdapter((JpaVendorAdapter)va);
        Properties props = new Properties();
        if (this.hbm2ddlAuto != null) {
            props.setProperty("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        }
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQL5InnoDBDialect");
        props.setProperty("hibernate.ejb.naming_strategy", "org.hibernate.cfg.ImprovedNamingStrategy");
        props.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        props.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
        props.setProperty("jadira.usertype.databaseZone", "jvm");
        props.setProperty("hibernate.show_sql", this.showSql);
        props.setProperty("hibernate.format_sql", "true");
        props.setProperty("hibernate.show_comments", "false");
        emf.setJpaProperties(props);
        return emf;
    }

    @Bean
    public ManifestStore manifestStore(JpaManifestItemRepo manifestRepo) {
        return new JpaManifestStore(manifestRepo);
    }
}

