/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.model;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.codec.digest.DigestUtils;
import org.duracloud.mill.db.model.BaseEntity;

@Entity
@Table(name="manifest_item", uniqueConstraints={@UniqueConstraint(columnNames={"uniqueKey"})})
public class ManifestItem
extends BaseEntity {
    @Column(nullable=false)
    private String account;
    @Column(nullable=false)
    private String storeId;
    @Column(nullable=false)
    private String spaceId;
    @Column(nullable=false, length=1024)
    private String contentId;
    @Column(nullable=false)
    private String contentChecksum;
    @Column(nullable=false)
    private String contentSize;
    @Column(nullable=false)
    private String contentMimetype;
    private boolean missingFromStorageProvider = false;
    private boolean deleted = false;
    private String uniqueKey;

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getContentChecksum() {
        return this.contentChecksum;
    }

    public void setContentChecksum(String contentChecksum) {
        this.contentChecksum = contentChecksum;
    }

    @Access(value=AccessType.PROPERTY)
    @Column(columnDefinition="char(32) NOT NULL")
    public String getUniqueKey() {
        if (this.uniqueKey == null) {
            this.uniqueKey = DigestUtils.md5Hex((String)(this.account + "/" + this.storeId + "/" + this.spaceId + "/" + this.contentId));
        }
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getContentMimetype() {
        return this.contentMimetype;
    }

    public void setContentMimetype(String contentMimetype) {
        this.contentMimetype = contentMimetype;
    }

    public String getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(String contentSize) {
        this.contentSize = contentSize;
    }

    public boolean isMissingFromStorageProvider() {
        return this.missingFromStorageProvider;
    }

    public void setMissingFromStorageProvider(boolean missingFromStorageProvider) {
        this.missingFromStorageProvider = missingFromStorageProvider;
    }
}

