/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.auditor.jpa;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.duracloud.common.collection.IteratorSource;
import org.duracloud.common.collection.StreamingIterator;
import org.duracloud.common.collection.jpa.JpaIteratorSource;
import org.duracloud.common.db.error.NotFoundException;
import org.duracloud.mill.auditor.AuditLogItem;
import org.duracloud.mill.auditor.AuditLogStore;
import org.duracloud.mill.auditor.AuditLogWriteFailedException;
import org.duracloud.mill.db.model.JpaAuditLogItem;
import org.duracloud.mill.db.repo.JpaAuditLogItemRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class JpaAuditLogStore
implements AuditLogStore {
    private static Logger log = LoggerFactory.getLogger(JpaAuditLogStore.class);
    private JpaAuditLogItemRepo auditLogRepo;

    @Autowired
    public JpaAuditLogStore(JpaAuditLogItemRepo auditLogRepo) {
        this.auditLogRepo = auditLogRepo;
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void write(String account, String storeId, String spaceId, String contentId, String contentMd5, String mimetype, String contentSize, String user, String action, String properties, String spaceAcls, String sourceSpaceId, String sourceContentId, Date timestamp) throws AuditLogWriteFailedException {
        JpaAuditLogItem item = new JpaAuditLogItem();
        try {
            item.setAccount(account);
            item.setStoreId(storeId);
            item.setSpaceId(spaceId);
            item.setContentId(contentId);
            item.setContentMd5(contentMd5);
            item.setMimetype(mimetype);
            item.setContentSize(contentSize);
            item.setUsername(user);
            item.setAction(action);
            item.setContentProperties(properties);
            item.setSpaceAcls(spaceAcls);
            item.setSourceSpaceId(sourceSpaceId);
            item.setSourceContentId(sourceContentId);
            item.setTimestamp(timestamp.getTime());
            item.setModified(timestamp);
            this.auditLogRepo.saveAndFlush(item);
            log.debug("item saved: {}", (Object)item);
        }
        catch (Exception ex) {
            if (ex instanceof DataIntegrityViolationException) {
                log.warn("failed to add audit log item {}: due to data integrity violation: suspected duplicate record: -> message={}", (Object)ex.getMessage());
            }
            throw new AuditLogWriteFailedException(ex, (AuditLogItem)item);
        }
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager", readOnly=true)
    public Iterator<AuditLogItem> getLogItems(final String account, final String storeId, final String spaceId, final String contentId) {
        return new StreamingIterator((IteratorSource)new JpaIteratorSource<JpaAuditLogItemRepo, JpaAuditLogItem>(this.auditLogRepo){

            protected Page<JpaAuditLogItem> getNextPage(Pageable pageable, JpaAuditLogItemRepo repo) {
                return repo.findByAccountAndStoreIdAndSpaceIdAndContentIdOrderByContentIdAsc(account, storeId, spaceId, contentId, pageable);
            }
        });
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager", readOnly=true)
    public AuditLogItem getLatestLogItem(String account, String storeId, String spaceId, String contentId) throws NotFoundException {
        List<JpaAuditLogItem> result = this.auditLogRepo.findByAccountAndStoreIdAndSpaceIdAndContentIdOrderByTimestampDesc(account, storeId, spaceId, contentId);
        if (!CollectionUtils.isEmpty(result)) {
            return result.get(0);
        }
        return null;
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void updateProperties(AuditLogItem item, String properties) throws AuditLogWriteFailedException {
        if (!(item instanceof JpaAuditLogItem)) {
            throw new AuditLogWriteFailedException("audit log item must be of type JpaAuditLogItem when used with this implementation: item is of type " + item.getClass().getCanonicalName(), item);
        }
        Long id = ((JpaAuditLogItem)item).getId();
        JpaAuditLogItem refreshedItem = (JpaAuditLogItem)this.auditLogRepo.findOne(id);
        refreshedItem.setContentProperties(properties);
        this.auditLogRepo.saveAndFlush(refreshedItem);
    }
}

