/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.repo;

import java.text.MessageFormat;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.common.db.jpa.JpaConfigurationUtil;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.manifest.jpa.JpaManifestStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.mill"}, entityManagerFactoryRef="millRepoEntityManagerFactory", transactionManagerRef="millJpaRepoTransactionManager")
@EnableTransactionManagement
public class MillJpaRepoConfig {
    private static final String MILL_REPO_ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";
    public static final String MILL_REPO_DATA_SOURCE_BEAN = "millRepoDataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "millJpaRepoTransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";
    @Autowired
    private Environment env;

    @Bean(name={"millRepoDataSource"}, destroyMethod="close")
    public BasicDataSource millRepoDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}?useLegacyDatetimeCode=false&serverTimezone=GMT&characterEncoding=utf8&characterSetResults=utf8", this.env.getProperty("mill.db.host", "localhost"), this.env.getProperty("mill.db.port", "3306"), this.env.getProperty("mill.db.name", "mill")));
        dataSource.setUsername(this.env.getProperty("mill.db.user", "user"));
        dataSource.setPassword(this.env.getProperty("mill.db.pass", "pass"));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    @Bean(name={"millJpaRepoTransactionManager"})
    public PlatformTransactionManager millRepoTransactionManager(@Qualifier(value="millRepoEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"millRepoEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean millRepoEntityManagerFactory(@Qualifier(value="millRepoDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("mill-repo-pu");
        emf.setPackagesToScan(new String[]{"org.duracloud.mill"});
        JpaConfigurationUtil.configureEntityManagerFactory((Environment)this.env, (LocalContainerEntityManagerFactoryBean)emf);
        if (Boolean.parseBoolean(this.env.getProperty("generate.database", "false"))) {
            Properties properties = new Properties();
            properties.setProperty("javax.persistence.schema-generation.database.action", "create");
            emf.setJpaProperties(properties);
        }
        return emf;
    }

    @Bean
    public ManifestStore manifestStore(JpaManifestItemRepo manifestRepo) {
        return new JpaManifestStore(manifestRepo);
    }
}

