/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.manifest.jpa;

import java.util.Collection;
import java.util.List;
import org.duracloud.common.collection.IteratorSource;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.springframework.util.CollectionUtils;

public class ManifestItemIteratorSource
implements IteratorSource<ManifestItem> {
    private JpaManifestItemRepo repo;
    private Long markerId = null;
    private String account;
    private String spaceId;
    private String storeId;
    private int pageSize;

    public ManifestItemIteratorSource(JpaManifestItemRepo repo, String account, String storeId, String spaceId, int pageSize) {
        this.repo = repo;
        this.account = account;
        this.storeId = storeId;
        this.spaceId = spaceId;
        this.pageSize = pageSize;
    }

    public Collection<ManifestItem> getNext() {
        if (this.markerId == null) {
            this.markerId = this.repo.getMinId(this.account, this.storeId, this.spaceId) - 1L;
        }
        assert (this.markerId != null);
        List<ManifestItem> items = this.repo.findByAccountAndStoreIdAndSpaceIdAndDeletedFalse(this.account, this.storeId, this.spaceId, this.markerId, this.pageSize);
        if (!CollectionUtils.isEmpty(items)) {
            this.markerId = items.get(items.size() - 1).getId();
            return items;
        }
        return null;
    }
}

