/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duraboss.rest;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.duracloud.appconfig.domain.DurabossConfig;
import org.duracloud.appconfig.xml.DurabossInitDocumentBinding;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.rest.RestUtil;
import org.duracloud.common.util.InitUtil;
import org.duracloud.duraboss.rest.BaseRest;
import org.duracloud.duraboss.rest.report.StorageReportResource;
import org.duracloud.security.context.SecurityContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/init")
@Component
public class InitRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(InitRest.class);
    private StorageReportResource storageResource;
    private SecurityContextUtil securityContextUtil;
    private RestUtil restUtil;
    private String reportSpaceId;
    private NotificationManager notificationManager;

    @Autowired
    public InitRest(StorageReportResource storageResource, SecurityContextUtil securityContextUtil, RestUtil restUtil, String reportSpaceId, NotificationManager notificationManager) {
        this.storageResource = storageResource;
        this.securityContextUtil = securityContextUtil;
        this.restUtil = restUtil;
        this.reportSpaceId = reportSpaceId;
        this.notificationManager = notificationManager;
    }

    @POST
    public Response initialize() {
        this.log.debug("Initializing DuraBoss");
        RestUtil.RequestContent content = null;
        try {
            content = this.restUtil.getRequestContent(this.request, this.headers);
            this.doInitialize(content.getContentStream());
            String responseText = "Initialization Successful";
            return this.responseOk(responseText);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    private void doInitialize(InputStream xml) throws NoUserLoggedInException {
        DurabossConfig config = DurabossInitDocumentBinding.createDurabossConfigFrom((InputStream)xml);
        Credential credential = this.securityContextUtil.getCurrentUser();
        String host = config.getDurastoreHost();
        String port = config.getDurastorePort();
        String context = config.getDurastoreContext();
        ContentStoreManagerImpl storeMgr = new ContentStoreManagerImpl(host, port, context);
        storeMgr.login(credential);
        context = config.getDurabossContext();
        this.notificationManager.initializeNotifiers(config.getNotificationConfigs());
        if (config.isReporterEnabled()) {
            this.storageResource.initialize((ContentStoreManager)storeMgr, this.reportSpaceId);
        }
    }

    @GET
    public Response isInitialized() {
        this.log.debug("checking initialized");
        boolean initialized = this.storageResource.isInitialized();
        if (initialized) {
            String text = InitUtil.getInitializedText((String)"DuraBoss");
            return this.responseOk(text);
        }
        String text = InitUtil.getNotInitializedText((String)"DuraBoss");
        return this.responseBad(text, Response.Status.SERVICE_UNAVAILABLE);
    }
}

