/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duraboss.rest.report;

import java.io.InputStream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.duracloud.duraboss.rest.BaseRest;
import org.duracloud.duraboss.rest.report.StorageReportResource;
import org.duracloud.reporter.error.InvalidScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/report/storage")
@Component
public class StorageReportRest
extends BaseRest {
    private StorageReportResource resource;
    private final Logger log = LoggerFactory.getLogger(StorageReportRest.class);

    @Autowired
    public StorageReportRest(StorageReportResource resource) {
        this.resource = resource;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getLatestStorageReport() {
        this.log.debug("Getting the latest storage report");
        try {
            InputStream stream = this.resource.getLatestStorageReport();
            if (null != stream) {
                return this.responseOkXmlStream(stream);
            }
            return this.responseNotFound();
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @Path(value="/list")
    @GET
    @Produces(value={"application/xml"})
    public Response getStorageReportList() {
        this.log.debug("Getting storage report list");
        try {
            String xml = this.resource.getStorageReportList();
            return this.responseOkXml(xml);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @Path(value="/{reportID: [^?]+}")
    @GET
    @Produces(value={"application/xml"})
    public Response getStorageReport(@PathParam(value="reportID") String reportId) {
        this.log.debug("Getting storage report with ID: " + reportId);
        try {
            InputStream stream = this.resource.getStorageReport(reportId);
            if (null != stream) {
                return this.responseOkXmlStream(stream);
            }
            return this.responseNotFound();
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @Path(value="/info")
    @GET
    @Produces(value={"application/xml"})
    public Response getStorageReportInfo() {
        this.log.debug("Getting storage report info");
        try {
            String xml = this.resource.getStorageReportInfo();
            return this.responseOkXml(xml);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @POST
    public Response startStorageReport() {
        this.log.debug("Starting storage report");
        try {
            String responseText = this.resource.startStorageReport();
            return this.responseOk(responseText);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @DELETE
    public Response cancelStorageReport() {
        this.log.debug("Cancelling storage report");
        try {
            String responseText = this.resource.cancelStorageReport();
            return this.responseOk(responseText);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @Path(value="/schedule")
    @POST
    public Response scheduleStorageReport(@QueryParam(value="startTime") long startTime, @QueryParam(value="frequency") long frequency) {
        this.log.debug("Scheduling a storage report series");
        try {
            String responseText = this.resource.scheduleStorageReport(startTime, frequency);
            return this.responseOk(responseText);
        }
        catch (InvalidScheduleException e) {
            return this.responseBadRequest((Exception)((Object)e));
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }

    @Path(value="/schedule")
    @DELETE
    public Response cancelStorageReportSchedule() {
        this.log.debug("Cancelling all scheduled storage reports");
        try {
            String responseText = this.resource.cancelStorageReportSchedule();
            return this.responseOk(responseText);
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }
}

