/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duraboss.rest;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class BaseRest {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    protected UriInfo uriInfo;
    public static final String XML = "application/xml";
    public static final MediaType APPLICATION_XML = MediaType.APPLICATION_XML_TYPE;
    public static final MediaType TEXT_PLAIN = MediaType.TEXT_PLAIN_TYPE;
    public static final String APP_NAME = "DuraBoss";

    protected Response responseOk() {
        return Response.ok().build();
    }

    protected Response responseOk(String text) {
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    protected Response responseOkStream(InputStream text) {
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    protected Response responseOkXml(String xml) {
        return Response.ok((Object)xml, (MediaType)APPLICATION_XML).build();
    }

    protected Response responseOkXmlStream(InputStream xml) {
        return Response.ok((Object)xml, (MediaType)APPLICATION_XML).build();
    }

    protected Response responseNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected Response responseNotFound(String msg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).build();
    }

    protected Response responseBadRequest(Exception e) {
        return this.responseBad(e, Response.Status.BAD_REQUEST);
    }

    protected Response responseBad(Exception e) {
        return this.responseBad(e, Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response responseBad(Exception e, Response.Status status) {
        String text = e.getMessage() == null ? "null" : e.getMessage();
        return this.responseBad(text, status);
    }

    protected Response responseBad(String text, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)text).build();
    }
}

