/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.util;

import java.util.List;
import java.util.Stack;
import org.duracloud.duradmin.util.DataRetrievalException;
import org.duracloud.duradmin.util.Scrollable;

public abstract class ScrollableList<E>
implements Scrollable<E> {
    private long maxResultsPerPage = 10L;
    private List<E> resultList;
    private boolean markedForUpdate = true;
    private E currentMarker = null;
    private Stack<E> markers = new Stack();

    @Override
    public long getMaxResultsPerPage() {
        return this.maxResultsPerPage;
    }

    public void markForUpdate() {
        this.markedForUpdate = true;
    }

    @Override
    public void setMaxResultsPerPage(int maxResults) {
        if (this.maxResultsPerPage != (long)maxResults) {
            this.maxResultsPerPage = maxResults;
            this.first();
        }
    }

    private E getLastResultInCurrentList() {
        List<E> results = this.resultList;
        if (results.size() > 0) {
            return results.get(results.size() - 1);
        }
        return null;
    }

    public void next() {
        if (!this.isNextAvailable()) {
            return;
        }
        E previousMarker = this.currentMarker;
        if (previousMarker != null) {
            this.markers.push(previousMarker);
        }
        this.currentMarker = this.getLastResultInCurrentList();
        this.markedForUpdate = true;
        try {
            this.update();
        }
        catch (DataRetrievalException ex) {
            if (previousMarker != null) {
                this.markers.pop();
            }
            this.currentMarker = previousMarker;
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void first() {
        this.markers.clear();
        this.currentMarker = null;
        this.markedForUpdate = true;
    }

    @Override
    public void previous() {
        if (this.isPreviousAvailable()) {
            this.currentMarker = this.markers.size() > 0 ? this.markers.pop() : null;
            this.markedForUpdate = true;
        }
    }

    @Override
    public boolean isPreviousAvailable() {
        return this.markers.size() > 0 || this.currentMarker != null;
    }

    public boolean isNextAvailable() {
        try {
            this.update();
            return (long)this.getResultList().size() >= this.maxResultsPerPage;
        }
        catch (DataRetrievalException e) {
            throw new RuntimeException(e);
        }
    }

    private E getCurrentMarker() {
        return this.currentMarker;
    }

    @Override
    public List<E> getResultList() {
        try {
            this.update();
            return this.resultList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final void update() throws DataRetrievalException {
        if (this.markedForUpdate) {
            this.resultList = this.getData(this.isPreviousAvailable() || this.currentMarker != null ? this.currentMarker : null);
            this.markedForUpdate = false;
        }
    }

    protected abstract List<E> getData(E var1) throws DataRetrievalException;
}

