/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.client.report.StorageReportManager;
import org.duracloud.client.report.error.NotFoundException;
import org.duracloud.client.report.error.ReportException;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.duradmin.control.StorageSummary;
import org.duracloud.duradmin.control.StorageSummaryCache;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reportdata.storage.metrics.SpaceMetrics;
import org.duracloud.reportdata.storage.metrics.StorageProviderMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StorageSummaryCacheImpl
implements StorageSummaryCache {
    private Logger log = LoggerFactory.getLogger(StorageSummaryCacheImpl.class);
    private StorageReportManager storageReportManager;
    private Map<String, List<StorageSummary>> summaryListCache = new HashMap<String, List<StorageSummary>>();
    private static final DateFormat REPORT_ID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final int DEFAULT_CACHE_RELOAD_FREQUENCY_IN_MINUTES = 60;
    private Timer timer = null;
    private boolean running = false;
    private int cacheReloadFrequencyInMinutes = 60;

    @Autowired
    public StorageSummaryCacheImpl(StorageReportManager storageReportManager) {
        this(storageReportManager, 60);
    }

    public StorageSummaryCacheImpl(StorageReportManager storageReportManager, int cacheReloadFrequencyInMinutes) {
        if (storageReportManager == null) {
            throw new IllegalArgumentException("The storageReportManager must be non-null");
        }
        this.storageReportManager = storageReportManager;
        this.cacheReloadFrequencyInMinutes = cacheReloadFrequencyInMinutes;
    }

    @Override
    public void init() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.running = false;
        long frequency = this.cacheReloadFrequencyInMinutes * 60 * 1000;
        class LoadTimerTask
        extends TimerTask {
            LoadTimerTask() {
            }

            @Override
            public void run() {
                if (StorageSummaryCacheImpl.this.running) {
                    StorageSummaryCacheImpl.this.log.info("Storage summary cache is being built. Skipping cache load...");
                    return;
                }
                try {
                    StorageSummaryCacheImpl.this.running = true;
                    StorageSummaryCacheImpl.this.log.info("loading storage summary cache...");
                    StorageSummaryCacheImpl.this.loadCache();
                    StorageSummaryCacheImpl.this.log.info("loaded storage summary cache.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                StorageSummaryCacheImpl.this.running = false;
            }
        }
        this.timer.schedule((TimerTask)new LoadTimerTask(), new Date(), frequency);
    }

    private Long parseDateFromReportId(String reportId) {
        String dateString = reportId.replace("report/storage-report-", "").replace(".xml", "");
        try {
            return REPORT_ID_DATE_FORMAT.parse(dateString).getTime();
        }
        catch (ParseException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    private void loadCache() throws Exception {
        this.log.info("retrieving report list...");
        List list = this.storageReportManager.getStorageReportList();
        this.log.info("approximately " + list.size() + " reports in list");
        HashMap<String, List<StorageSummary>> newCache = new HashMap<String, List<StorageSummary>>();
        for (String reportId : list) {
            if (!reportId.endsWith("xml")) continue;
            this.appendSummaries(newCache, reportId);
        }
        this.summaryListCache = newCache;
    }

    private void appendSummaries(Map<String, List<StorageSummary>> cache, String reportId) throws NotFoundException, ReportException {
        Long dateInMs = this.parseDateFromReportId(reportId);
        StorageReport report = this.storageReportManager.getStorageReport(reportId);
        for (StorageProviderMetrics spm : report.getStorageMetrics().getStorageProviderMetrics()) {
            String storeId = spm.getStorageProviderId();
            StorageSummary sps = new StorageSummary(dateInMs, spm.getTotalSize(), spm.getTotalItems(), reportId);
            this.appendToSummaryList(storeId, sps, cache);
            for (SpaceMetrics spaceMetrics : spm.getSpaceMetrics()) {
                StorageSummary spaceSummary = new StorageSummary(dateInMs, spaceMetrics.getTotalSize(), spaceMetrics.getTotalItems(), reportId);
                this.appendToSummaryList(storeId, spaceMetrics.getSpaceName(), spaceSummary, cache);
            }
        }
        this.log.info("added storage summaries extracted from " + reportId);
    }

    private void appendToSummaryList(String storeId, StorageSummary summary, Map<String, List<StorageSummary>> cache) {
        this.appendToSummaryList(storeId, null, summary, cache);
    }

    private void appendToSummaryList(String storeId, String spaceId, StorageSummary summary, Map<String, List<StorageSummary>> cache) {
        List<StorageSummary> list = this.getSummaryList(storeId, spaceId, cache);
        list.add(summary);
    }

    private List<StorageSummary> getSummaryList(String storeId, String spaceId, Map<String, List<StorageSummary>> cache) {
        String key = this.formatKey(storeId, spaceId);
        List<StorageSummary> summaryList = cache.get(key);
        if (summaryList == null) {
            summaryList = new LinkedList<StorageSummary>();
            cache.put(key, summaryList);
        }
        return summaryList;
    }

    @Override
    public List<StorageSummary> getSummaries(String storeId, String spaceId) {
        if (storeId == null) {
            throw new IllegalArgumentException("storeId must be non-null");
        }
        return this.getSummaryList(storeId, spaceId, this.summaryListCache);
    }

    private String formatKey(String storeId, String spaceId) {
        return storeId + (spaceId != null ? "/" + spaceId : "");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

