/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.common.model.AclType;
import org.duracloud.common.util.TagUtil;
import org.duracloud.common.web.EncodeUtil;
import org.duracloud.domain.Content;
import org.duracloud.duradmin.config.DuradminConfig;
import org.duracloud.duradmin.domain.Acl;
import org.duracloud.duradmin.domain.ContentItem;
import org.duracloud.duradmin.domain.ContentProperties;
import org.duracloud.duradmin.domain.Space;
import org.duracloud.duradmin.domain.SpaceProperties;
import org.duracloud.error.ContentStateException;
import org.duracloud.error.ContentStoreException;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class SpaceUtil {
    private static Logger log = LoggerFactory.getLogger(SpaceUtil.class);
    private static final Comparator<Acl> ACL_COMPARATOR = new Comparator<Acl>(){
        private String groupPrefix = "group-";

        @Override
        public int compare(Acl o1, Acl o2) {
            if (o1.name.equals(o2.name)) {
                return 0;
            }
            if (o1.isPublicGroup()) {
                return -1;
            }
            if (o2.isPublicGroup()) {
                return 1;
            }
            if (o1.name.startsWith(this.groupPrefix)) {
                return !o2.name.startsWith(this.groupPrefix) ? -1 : o1.name.compareToIgnoreCase(o2.name);
            }
            return o2.name.startsWith(this.groupPrefix) ? 1 : o1.name.compareToIgnoreCase(o2.name);
        }
    };

    public static Space populateSpace(Space space, org.duracloud.domain.Space cloudSpace, ContentStore contentStore, Authentication authentication) throws ContentStoreException {
        space.setSpaceId(cloudSpace.getId());
        space.setProperties(SpaceUtil.getSpaceProperties(cloudSpace.getProperties()));
        space.setStreamingEnabled(StringUtils.isNotBlank((String)space.getProperties().getStreamingHost()));
        space.setExtendedProperties(cloudSpace.getProperties());
        space.setContents(cloudSpace.getContentIds());
        Map spaceAcls = contentStore.getSpaceACLs(cloudSpace.getId());
        space.setAcls(SpaceUtil.toAclList(spaceAcls));
        if (SpaceUtil.isAdmin(authentication) && SpaceUtil.isSnapshotProvider(contentStore) && SpaceUtil.isSnapshotInProgress(contentStore, space.getSpaceId())) {
            space.setSnapshotInProgress(true);
        }
        AclType callerAcl = SpaceUtil.resolveCallerAcl(space.getSpaceId(), contentStore, spaceAcls, authentication, space.isSnapshotInProgress());
        String aclName = null;
        if (null != callerAcl) {
            aclName = callerAcl.name();
        }
        space.setCallerAcl(aclName);
        space.setMillDbEnabled(DuradminConfig.isMillDbEnabled());
        return space;
    }

    private static SpaceProperties getSpaceProperties(Map<String, String> spaceProps) {
        SpaceProperties spaceProperties = new SpaceProperties();
        spaceProperties.setCreated(spaceProps.remove("space-created"));
        spaceProperties.setCount(spaceProps.remove("space-count"));
        spaceProperties.setSize(spaceProps.remove("space-total-size"));
        spaceProperties.setTags(TagUtil.parseTags((String)spaceProps.remove("tags")));
        spaceProperties.setStreamingHost(spaceProps.get("streaming-host"));
        spaceProperties.setStreamingType(spaceProps.get("streaming-type"));
        spaceProperties.setSnapshotId(spaceProps.get("snapshot-id"));
        String restoreId = spaceProps.get("restore-id");
        if (StringUtils.isNotBlank((String)restoreId)) {
            spaceProperties.setRestoreId(restoreId);
        }
        return spaceProperties;
    }

    public static void populateContentItem(String duradminBaseURL, ContentItem contentItem, String spaceId, String contentId, ContentStore store, Authentication authentication) throws ContentStoreException {
        contentItem.setSpaceId(spaceId);
        contentItem.setContentId(contentId);
        contentItem.setStoreId(store.getStoreId());
        Map contentProperties = store.getContentProperties(spaceId, contentId);
        ContentProperties properties = SpaceUtil.populateContentProperties(contentProperties);
        contentItem.setProperties(properties);
        contentItem.setExtendedProperties(contentProperties);
        contentItem.setDurastoreURL(SpaceUtil.formatDurastoreURL(contentItem, store));
        Map acls = store.getSpaceACLs(spaceId);
        contentItem.setAcls(SpaceUtil.toAclList(acls));
        AclType callerAcl = SpaceUtil.resolveCallerAcl(spaceId, store, acls, authentication);
        String aclName = null;
        if (null != callerAcl) {
            aclName = callerAcl.name();
        }
        contentItem.setCallerAcl(aclName);
        contentItem.setImageViewerBaseURL(null);
    }

    private static String formatDurastoreURL(ContentItem contentItem, ContentStore store) {
        String pattern = "{0}/{1}/{2}?storeID={3}";
        return MessageFormat.format(pattern, store.getBaseURL().replace("https", "http"), contentItem.getSpaceId(), EncodeUtil.urlEncode((String)contentItem.getContentId()), store.getStoreId());
    }

    private static ContentProperties populateContentProperties(Map<String, String> contentProperties) {
        ContentProperties properties = new ContentProperties();
        properties.setMimetype(contentProperties.remove("content-mimetype"));
        properties.setSize(contentProperties.remove("content-size"));
        properties.setChecksum(contentProperties.remove("content-checksum"));
        properties.setModified(contentProperties.remove("content-modified"));
        properties.setTags(TagUtil.parseTags((String)contentProperties.remove("tags")));
        return properties;
    }

    public static void streamContent(ContentStore store, HttpServletResponse response, String spaceId, String contentId) throws ContentStoreException, IOException {
        Content c = store.getContent(spaceId, contentId);
        Map m = store.getContentProperties(spaceId, contentId);
        String mimetype = (String)m.get("content-mimetype");
        String contentLength = (String)m.get("content-size");
        try (InputStream is = c.getStream();){
            SpaceUtil.streamToResponse(is, response, mimetype, contentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamToResponse(InputStream is, HttpServletResponse response, String mimetype, String contentLength) throws ContentStoreException, IOException {
        block14: {
            ServletOutputStream outStream = response.getOutputStream();
            try {
                response.setContentType(mimetype);
                if (contentLength != null) {
                    response.setContentLengthLong(Long.parseLong(contentLength));
                }
                byte[] buf = new byte[1024];
                int read = -1;
                while ((read = is.read(buf)) > 0) {
                    outStream.write(buf, 0, read);
                }
                response.flushBuffer();
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof ContentStateException) {
                    response.reset();
                    response.setStatus(409);
                    String message = "The requested content item is currently in long-term storage with limited retrieval capability. Please contact DuraCloud support (https://wiki.duraspace.org/x/6gPNAQ) for assistance in retrieving this content item.";
                    message = message + StringUtils.repeat((String)" ", (int)512);
                    outStream.write(message.getBytes());
                    break block14;
                }
                throw ex;
            }
            finally {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    log.warn("failed to close outputstream ( " + outStream + "): message=" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static AclType resolveCallerAcl(String spaceId, ContentStore store, Map<String, AclType> acls, Authentication authentication) throws ContentStoreException {
        return SpaceUtil.resolveCallerAcl(spaceId, store, acls, authentication, null);
    }

    public static AclType resolveCallerAcl(String spaceId, ContentStore store, Map<String, AclType> acls, Authentication authentication, Boolean snapshotInProgress) throws ContentStoreException {
        if (SpaceUtil.isRoot(authentication)) {
            return AclType.WRITE;
        }
        if (snapshotInProgress == null) {
            snapshotInProgress = false;
            if (SpaceUtil.isSnapshotProvider(store)) {
                snapshotInProgress = SpaceUtil.isSnapshotInProgress(store, spaceId);
            }
        }
        if (spaceId.equals("x-snapshot-metadata")) {
            return AclType.READ;
        }
        if (snapshotInProgress.booleanValue()) {
            return AclType.READ;
        }
        if (SpaceUtil.isAdmin(authentication)) {
            return AclType.WRITE;
        }
        AclType callerAcl = null;
        DuracloudUserDetails details = (DuracloudUserDetails)authentication.getPrincipal();
        List userGroups = details.getGroups();
        for (Map.Entry<String, AclType> e : acls.entrySet()) {
            AclType value = e.getValue();
            if (!e.getKey().equals(details.getUsername()) && !userGroups.contains(e.getKey()) || !AclType.WRITE.equals((Object)(callerAcl = value))) continue;
            break;
        }
        return callerAcl;
    }

    private static boolean isSnapshotInProgress(ContentStore store, String spaceId) throws ContentStoreException {
        return store.getSpaceProperties(spaceId).containsKey("snapshot-id");
    }

    protected static boolean isSnapshotProvider(ContentStore store) {
        String providerType = store.getStorageProviderType();
        return providerType.equals(StorageProviderType.DPN.name()) || providerType.equals(StorageProviderType.CHRONOPOLIS.name());
    }

    public static boolean isAdmin(Authentication authentication) {
        return SpaceUtil.hasRole(authentication, "ROLE_ADMIN");
    }

    private static boolean isRoot(Authentication authentication) {
        return SpaceUtil.hasRole(authentication, "ROLE_ROOT");
    }

    protected static boolean hasRole(Authentication authentication, String role) {
        Collection authorities = authentication.getAuthorities();
        for (Object a : authorities) {
            if (!((GrantedAuthority)a).getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }

    public static List<Acl> toAclList(Map<String, AclType> spaceACLs) {
        LinkedList<Acl> acls = new LinkedList<Acl>();
        if (spaceACLs != null) {
            for (Map.Entry<String, AclType> entry : spaceACLs.entrySet()) {
                String key = entry.getKey();
                AclType value = entry.getValue();
                boolean read = false;
                boolean write = false;
                if (value.equals((Object)AclType.READ)) {
                    read = true;
                } else if (value.equals((Object)AclType.WRITE)) {
                    read = true;
                    write = true;
                }
                acls.add(new Acl(key, SpaceUtil.formatAclDisplayName(key), read, write));
            }
        }
        SpaceUtil.sortAcls(acls);
        return acls;
    }

    public static void sortAcls(List<Acl> acls) {
        Collections.sort(acls, ACL_COMPARATOR);
    }

    public static String formatAclDisplayName(String key) {
        String prefix = "group-";
        if (key.startsWith(prefix)) {
            return key.replaceFirst(prefix, "");
        }
        return key;
    }
}

