/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonValueProcessorMatcher;
import net.sf.json.util.JsonEventListener;
import net.sf.json.util.PropertyFilter;
import org.duracloud.duradmin.util.JsonlibJsonStringWriterWithDates;
import org.duracloud.snapshot.dto.SnapshotHistoryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplateRegistry;
import org.springframework.web.servlet.view.json.writer.jsonlib.AllwaysMatchingValueProcessorMatcher;
import org.springframework.web.servlet.view.json.writer.jsonlib.JsonlibJsonStringWriter;
import org.springframework.web.servlet.view.json.writer.jsonlib.JsonlibJsonWriterConfiguratorTemplate;
import org.springframework.web.servlet.view.json.writer.jsonlib.NullPropertyFilter;
import org.springframework.web.servlet.view.json.writer.jsonlib.PropertyEditorRegistryValueProcessor;

public class JsonlibJsonStringWriterWithDates
extends JsonlibJsonStringWriter {
    protected final Logger logger = LoggerFactory.getLogger(JsonlibJsonStringWriterWithDates.class);

    public void convertAndWrite(Map model, JsonWriterConfiguratorTemplateRegistry configuratorTemplateRegistry, Writer writer, BindingResult br) throws IOException {
        JsonConfig jsonConfig = null;
        JsonlibJsonWriterConfiguratorTemplate configuratorTemplate = (JsonlibJsonWriterConfiguratorTemplate)configuratorTemplateRegistry.findConfiguratorTemplate(JsonlibJsonWriterConfiguratorTemplate.class.getName());
        if (this.isEnableJsonConfigSupport() && configuratorTemplate != null) {
            jsonConfig = (JsonConfig)configuratorTemplate.getConfigurator();
        }
        if (jsonConfig == null) {
            jsonConfig = new JsonConfig();
        }
        if (jsonConfig.getJsonPropertyFilter() == null && !this.isKeepNullProperties()) {
            jsonConfig.setJsonPropertyFilter((PropertyFilter)new NullPropertyFilter());
        }
        if (jsonConfig.getJsonValueProcessorMatcher().getClass().equals(JsonValueProcessorMatcher.DEFAULT.getClass())) {
            PropertyEditorRegistry per = null;
            String objektName = null;
            if (br != null) {
                per = br.getPropertyEditorRegistry();
                objektName = br.getObjectName();
            }
            PropertyEditorRegistryValueProcessor valueProzessor = new PropertyEditorRegistryValueProcessor(per);
            valueProzessor.setConvertAllMapValues(this.isConvertAllMapValues());
            valueProzessor.setObjektName(objektName);
            jsonConfig.registerJsonValueProcessor(AllwaysMatchingValueProcessorMatcher.class, (JsonValueProcessor)valueProzessor);
            jsonConfig.setJsonValueProcessorMatcher((JsonValueProcessorMatcher)new AllwaysMatchingValueProcessorMatcher());
            jsonConfig.addJsonEventListener((JsonEventListener)valueProzessor);
            jsonConfig.enableEventTriggering();
        }
        jsonConfig.registerJsonBeanProcessor(SnapshotHistoryItem.class, (JsonBeanProcessor)new SnapshotHistoryItemJsonBeanProcessor());
        JSON json = JSONSerializer.toJSON((Object)model, (JsonConfig)jsonConfig);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(json.toString());
        }
        json.write(writer);
        writer.flush();
    }
}

