/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.util;

import javax.servlet.http.HttpServletRequest;
import org.duracloud.duradmin.util.NameValuePair;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.Severity;
import org.springframework.web.servlet.ModelAndView;

public class MessageUtils {
    protected static final String REDIRECT_KEY = "redirectKey";
    public static final String FLASH_MESSAGE = "flashMessage";

    private MessageUtils() {
    }

    public static void addFlashMessage(Message message, HttpServletRequest request) {
        request.setAttribute(FLASH_MESSAGE, (Object)message);
    }

    public static String addMessageToRedirect(Message message, HttpServletRequest request) {
        String key = String.valueOf(System.currentTimeMillis());
        request.getSession().setAttribute(key, (Object)new NameValuePair(FLASH_MESSAGE, message));
        return key;
    }

    public static Message getRedirectMessage(HttpServletRequest request) {
        String key = request.getParameter(REDIRECT_KEY);
        NameValuePair obj = (NameValuePair)request.getSession().getAttribute(key);
        if (obj != null) {
            request.getSession().removeAttribute(key);
            return (Message)obj.getValue();
        }
        return null;
    }

    public static String appendRedirectMessage(String outcomeUrl, Message message, HttpServletRequest request) {
        String key = MessageUtils.addMessageToRedirect(message, request);
        int index = ((String)(outcomeUrl = !((String)outcomeUrl).contains("?") ? (String)outcomeUrl + "?" : (String)outcomeUrl + "&")).indexOf(REDIRECT_KEY);
        if (index > 0) {
            int start = index + REDIRECT_KEY.length() + 1;
            int end = ((String)outcomeUrl).indexOf("=", start);
            if (end < 0) {
                end = ((String)outcomeUrl).length();
            }
            String value = ((String)outcomeUrl).substring(start, end);
            outcomeUrl = ((String)outcomeUrl).replace("redirectKey=" + value, "redirectKey=" + key);
        } else {
            outcomeUrl = (String)outcomeUrl + "redirectKey=" + key;
        }
        return outcomeUrl;
    }

    public static void addRedirectMessageToModelAndView(ModelAndView modelAndView, HttpServletRequest request) {
        Message message = MessageUtils.getRedirectMessage(request);
        if (message != null) {
            modelAndView.addObject(FLASH_MESSAGE, (Object)message);
        }
    }

    public static Message createMessage(String string) {
        return MessageUtils.createMessage(string, Severity.INFO);
    }

    public static void addFlashMessage(String messageText, ModelAndView mav) {
        mav.addObject(FLASH_MESSAGE, (Object)MessageUtils.createMessage(messageText));
    }

    public static Message createMessage(String string, Severity severity) {
        Message message = new Message(null, string, severity);
        return message;
    }
}

