/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.duracloud.common.web.EncodeUtil;
import org.duracloud.duradmin.domain.Acl;
import org.duracloud.duradmin.domain.ContentProperties;
import org.duracloud.duradmin.util.NameValuePair;
import org.duracloud.duradmin.util.PropertiesUtils;
import org.hibernate.validator.constraints.NotBlank;

public class ContentItem
implements Serializable {
    private static final long serialVersionUID = -5835779644282347055L;
    private String action;
    @NotBlank
    private String spaceId;
    @NotBlank
    private String contentId;
    @NotBlank
    private String storeId;
    private boolean primaryStorageProvider;
    private String contentMimetype;
    private String durastoreURL;
    private List<NameValuePair> extendedProperties;
    private ContentProperties properties;
    private String imageViewerBaseURL;
    private String callerAcl;
    private List<Acl> acls;

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getEncodedContentId() {
        String contentId = this.getContentId();
        return EncodeUtil.urlEncode((String)contentId);
    }

    public String getContentMimetype() {
        return this.contentMimetype;
    }

    public void setContentMimetype(String contentMimetype) {
        this.contentMimetype = contentMimetype;
    }

    public ContentProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ContentProperties properties) {
        this.properties = properties;
    }

    public List<NameValuePair> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = PropertiesUtils.convertExtendedProperties(extendedProperties);
    }

    public void setDurastoreURL(String durastoreURL) {
        this.durastoreURL = durastoreURL;
    }

    public String getDurastoreURL() {
        return this.durastoreURL;
    }

    public String getCallerAcl() {
        return this.callerAcl;
    }

    public void setCallerAcl(String callerAcl) {
        this.callerAcl = callerAcl;
    }

    public List<Acl> getAcls() {
        return this.acls;
    }

    public void setAcls(List<Acl> acls) {
        this.acls = acls;
    }

    public String toString() {
        return "{storeId: " + this.storeId + ", spaceId: " + this.spaceId + ", contentId: " + this.contentId + ", properties: " + this.properties + ", contentMimetype: " + this.contentMimetype + ", callerAcl: " + this.callerAcl + "}";
    }

    public String getImageViewerBaseURL() {
        return this.imageViewerBaseURL;
    }

    public void setImageViewerBaseURL(String imageViewerBaseURL) {
        this.imageViewerBaseURL = imageViewerBaseURL;
    }

    public boolean isPrimaryStorageProvider() {
        return this.primaryStorageProvider;
    }

    public void setPrimaryStorageProvider(boolean primaryStorageProvider) {
        this.primaryStorageProvider = primaryStorageProvider;
    }
}

