/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.AclType;
import org.duracloud.duradmin.domain.Space;
import org.duracloud.duradmin.util.SpaceUtil;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SpacesController {
    protected final Logger log = LoggerFactory.getLogger(SpacesController.class);
    @Autowired
    @Qualifier(value="contentStoreManager")
    private ContentStoreManager contentStoreManager;

    public ContentStoreManager getContentStoreManager() {
        return this.contentStoreManager;
    }

    public void setContentStoreManager(ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
    }

    @RequestMapping(value={"/spaces/json"})
    public ModelAndView getSpacesAsJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("jsonView");
        try {
            Object acl;
            String writeableOnlyStr = request.getParameter("writeableOnly");
            boolean writeableOnly = Boolean.parseBoolean(writeableOnlyStr);
            String storeId = request.getParameter("storeId");
            ContentStore c = this.contentStoreManager.getContentStore(storeId);
            List spaceIds = c.getSpaces();
            LinkedList<Space> spaces = new LinkedList<Space>();
            Authentication a = SecurityContextHolder.getContextHolderStrategy().getContext().getAuthentication();
            ContentStore contentStoreWithoutRetries = this.contentStoreManager.getContentStore(storeId, 0);
            for (String spaceId : spaceIds) {
                acl = SpaceUtil.resolveCallerAcl((String)spaceId, (ContentStore)contentStoreWithoutRetries, (Map)c.getSpaceACLs(spaceId), (Authentication)a);
                Space space = new Space();
                space.setCallerAcl(acl != null ? acl.name() : null);
                space.setSpaceId(spaceId);
                space.setStoreId(storeId);
                spaces.add(space);
            }
            if (writeableOnly && !SpaceUtil.isAdmin((Authentication)a)) {
                for (int i = spaces.size() - 1; i > -1; --i) {
                    Space space = (Space)spaces.get(i);
                    acl = space.getCallerAcl();
                    if (AclType.WRITE.name().equals(acl)) continue;
                    spaces.remove(i);
                }
            }
            mav.addObject("spaces", spaces);
            return mav;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            mav.addObject("contentStores", new LinkedList());
            String error = "An error occurred attempting to retrieve your spaces. You may need to log out and back in to restore this feature. If this does not correct the problem, please contact your DuraCloud Administrator.";
            mav.addObject("error", (Object)error);
            return mav;
        }
    }

    @RequestMapping(value={"/spaces", "/spaces/sm/**"})
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("spaces-manager");
        try {
            LinkedList<ContentStore> stores = new LinkedList<ContentStore>();
            String primaryStoreId = this.contentStoreManager.getPrimaryContentStore().getStoreId();
            for (ContentStore store : this.contentStoreManager.getContentStores().values()) {
                if (store.getStoreId().equals(primaryStoreId)) {
                    stores.add(0, store);
                    continue;
                }
                stores.add(store);
            }
            mav.addObject("contentStores", stores);
            mav.addObject("user", (Object)((DuracloudUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()));
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            mav.addObject("contentStores", new LinkedList());
            String error = "An error occurred attempting to retrieve your spaces. You may need to log out and back in to restore this feature. If this does not correct the problem, please contact your DuraCloud Administrator.";
            mav.addObject("error", (Object)error);
        }
        return mav;
    }
}

