/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.text.MessageFormat;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.audit.reader.AuditLogEmptyException;
import org.duracloud.audit.reader.AuditLogReader;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/audit")
@Component
public class AuditLogRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(AuditLogRest.class);
    private AuditLogReader auditLogReader;
    private StorageProviderFactory storageProviderFactory;

    @Autowired
    public AuditLogRest(AuditLogReader auditLogReader, StorageProviderFactory storageProviderFactory) {
        this.auditLogReader = auditLogReader;
        this.storageProviderFactory = storageProviderFactory;
    }

    @Path(value="/{spaceId}")
    @GET
    public Response getAuditLog(@PathParam(value="spaceId") String spaceId, @QueryParam(value="storeID") String storeId) {
        String account = this.getSubdomain();
        this.log.info("getting audit log for account:{}, storeId:{}, spaceId:{}", new Object[]{account, storeId, spaceId});
        if (StringUtils.isBlank((CharSequence)storeId)) {
            for (StorageAccount storageAccount : this.storageProviderFactory.getStorageAccounts()) {
                if (!storageAccount.isPrimary()) continue;
                storeId = storageAccount.getId();
                break;
            }
            if (StringUtils.isBlank((CharSequence)storeId)) {
                throw new DuraCloudRuntimeException("storeId is blank and no primary storage account is indicated.");
            }
        }
        try {
            InputStream auditLog = this.auditLogReader.gitAuditLog(account, storeId, spaceId);
            return this.responseOkStream(auditLog);
        }
        catch (Exception e) {
            this.log.error(MessageFormat.format("Error for  account:{0}, storeId:{1}, spaceId:{2}", account, storeId, spaceId), (Throwable)e);
            if (e instanceof AuditLogEmptyException) {
                return this.responseNotFound("No audit logs found.");
            }
            return this.responseBad(e);
        }
    }
}

