/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.ManifestResource;
import org.duracloud.manifest.error.ManifestArgumentException;
import org.duracloud.manifest.error.ManifestNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/manifest")
@Component
public class ManifestRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(ManifestRest.class);
    private ManifestResource manifestResource;

    @Autowired
    public ManifestRest(ManifestResource manifestResource) {
        this.manifestResource = manifestResource;
    }

    @Path(value="/{spaceId}")
    @GET
    public Response getManifest(@PathParam(value="spaceId") String spaceId, @QueryParam(value="format") String format, @QueryParam(value="storeID") String storeId) {
        String account = this.getSubdomain();
        this.log.info("getting manifest, {}:{}:{} [{}]", new Object[]{account, storeId, spaceId, format});
        try {
            InputStream manifest = this.manifestResource.getManifest(account, storeId, spaceId, format);
            return this.responseOkStream(manifest);
        }
        catch (ManifestArgumentException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBadRequest((Exception)((Object)e));
        }
        catch (ManifestNotFoundException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseNotFound(e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBad(e);
        }
    }
}

