/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.AclType;
import org.duracloud.security.context.SecurityContextUtil;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class ACLStorageProvider
implements StorageProvider {
    private final Logger log = LoggerFactory.getLogger(ACLStorageProvider.class);
    private final StorageProvider targetProvider;
    private SecurityContextUtil securityContextUtil;
    private Map<String, Map<String, AclType>> spaceACLMap;
    private boolean loaded;

    public ACLStorageProvider(StorageProvider targetProvider) {
        this(targetProvider, new SecurityContextUtil());
    }

    public ACLStorageProvider(StorageProvider targetProvider, SecurityContextUtil securityContextUtil) {
        this.targetProvider = targetProvider;
        this.securityContextUtil = securityContextUtil;
        this.spaceACLMap = new HashMap<String, Map<String, AclType>>();
        this.loaded = false;
        new Thread(new CacheLoader()).start();
    }

    private void waitForCache() {
        while (!this.loaded) {
            this.log.debug("waiting: {}", (Object)this.targetProvider.getClass().getName());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Iterator<String> getSpaces() {
        DuracloudUserDetails user = this.getCurrentUserDetails();
        if (this.isAdmin(user)) {
            return this.targetProvider.getSpaces();
        }
        this.waitForCache();
        ArrayList<String> spaces = new ArrayList<String>();
        for (String space : this.spaceACLMap.keySet()) {
            Map<String, AclType> acls = this.spaceACLMap.get(space);
            if (!this.userHasAccess(user, acls) || spaces.contains(space)) continue;
            spaces.add(space);
        }
        Collections.sort(spaces);
        return spaces.iterator();
    }

    private boolean isAdmin(DuracloudUserDetails user) {
        if (null == user) {
            return false;
        }
        Collection auths = user.getAuthorities();
        if (null != auths) {
            for (GrantedAuthority auth : auths) {
                if (!"ROLE_ADMIN".equals(auth.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }

    private DuracloudUserDetails getCurrentUserDetails() {
        try {
            return this.securityContextUtil.getCurrentUserDetails();
        }
        catch (NoUserLoggedInException e) {
            return null;
        }
    }

    private boolean userHasAccess(DuracloudUserDetails user, Map<String, AclType> acls) {
        if (acls.keySet().contains("acl-group-public")) {
            return true;
        }
        if (null == user) {
            return false;
        }
        if (acls.keySet().contains("acl-" + user.getUsername())) {
            return true;
        }
        List groups = user.getGroups();
        if (null == groups || groups.size() == 0) {
            return false;
        }
        for (String group : groups) {
            if (!acls.keySet().contains("acl-" + group)) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> getSpaceContents(String spaceId, String prefix) {
        return this.targetProvider.getSpaceContents(spaceId, prefix);
    }

    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) {
        return this.targetProvider.getSpaceContentsChunked(spaceId, prefix, maxResults, marker);
    }

    public void createSpace(String spaceId) {
        this.waitForCache();
        this.targetProvider.createSpace(spaceId);
        DuracloudUserDetails userDetails = this.getCurrentUserDetails();
        if (null != userDetails) {
            HashMap<String, AclType> acl = new HashMap<String, AclType>();
            acl.put("acl-" + userDetails.getUsername(), AclType.WRITE);
            this.spaceACLMap.put(spaceId, acl);
        }
    }

    public void deleteSpace(String spaceId) {
        this.waitForCache();
        StorageException storageException = null;
        try {
            this.targetProvider.deleteSpace(spaceId);
            this.spaceACLMap.remove(spaceId);
        }
        catch (StorageException e) {
            storageException = e;
        }
        if ((this.getClass().getSimpleName() + "-cache").equalsIgnoreCase(spaceId)) {
            this.log.info("cycling cache.");
            this.spaceACLMap.clear();
            this.loaded = false;
            new Thread(new CacheLoader()).start();
        }
        if (null != storageException) {
            throw storageException;
        }
    }

    public Map<String, String> getSpaceProperties(String spaceId) {
        return this.targetProvider.getSpaceProperties(spaceId);
    }

    public Map<String, AclType> getSpaceACLs(String spaceId) {
        DuracloudUserDetails user = this.getCurrentUserDetails();
        if (this.isAdmin(user) && !this.loaded) {
            return this.targetProvider.getSpaceACLs(spaceId);
        }
        this.waitForCache();
        if (this.spaceACLMap.containsKey(spaceId)) {
            return this.spaceACLMap.get(spaceId);
        }
        Map acls = this.targetProvider.getSpaceACLs(spaceId);
        this.spaceACLMap.put(spaceId, acls);
        return acls;
    }

    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        this.waitForCache();
        this.targetProvider.setSpaceACLs(spaceId, spaceACLs);
        if (null != spaceACLs) {
            this.spaceACLMap.put(spaceId, spaceACLs);
        }
    }

    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) {
        return this.targetProvider.addContent(spaceId, contentId, contentMimeType, userProperties, contentSize, contentChecksum, content);
    }

    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        return this.targetProvider.copyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
    }

    public InputStream getContent(String spaceId, String contentId) {
        return this.targetProvider.getContent(spaceId, contentId);
    }

    public void deleteContent(String spaceId, String contentId) {
        this.targetProvider.deleteContent(spaceId, contentId);
    }

    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        this.targetProvider.setContentProperties(spaceId, contentId, contentProperties);
    }

    public Map<String, String> getContentProperties(String spaceId, String contentId) {
        return this.targetProvider.getContentProperties(spaceId, contentId);
    }

    private class CacheLoader
    implements Runnable {
        private CacheLoader() {
        }

        @Override
        public void run() {
            Iterator spaces = ACLStorageProvider.this.targetProvider.getSpaces();
            while (spaces.hasNext()) {
                String space = (String)spaces.next();
                ACLStorageProvider.this.spaceACLMap.put(space, this.getSpaceACLs(space));
            }
            ACLStorageProvider.this.loaded = true;
        }

        private Map<String, AclType> getSpaceACLs(String space) {
            try {
                return ACLStorageProvider.this.targetProvider.getSpaceACLs(space);
            }
            catch (StorageException e) {
                ACLStorageProvider.this.log.warn("Error getting space acls: {}, err: {}", (Object)space, (Object)e);
                return new HashMap<String, AclType>();
            }
        }
    }
}

