/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import com.amazonaws.services.s3.AmazonS3Client;
import org.duracloud.durastore.util.ProviderFactoryBase;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.glaciertask.GlacierTaskProvider;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.S3TaskProvider;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.SnapshotTaskProvider;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.jets3t.service.CloudFrontService;

public class TaskProviderFactory
extends ProviderFactoryBase {
    private StorageProviderFactory storageProviderFactory;

    public TaskProviderFactory(StorageAccountManager storageAccountManager, StorageProviderFactory storageProviderFactory) {
        super(storageAccountManager);
        this.storageProviderFactory = storageProviderFactory;
    }

    public TaskProvider getTaskProvider() {
        return this.getTaskProvider(null);
    }

    public TaskProvider getTaskProvider(String storageAccountId) throws TaskException {
        GlacierTaskProvider taskProvider;
        StorageAccountManager storageAccountManager = this.getAccountManager();
        StorageAccount account = storageAccountManager.getStorageAccount(storageAccountId);
        if (account == null) {
            account = storageAccountManager.getPrimaryStorageAccount();
            storageAccountId = account.getId();
        }
        String username = account.getUsername();
        String password = account.getPassword();
        StorageProviderType type = account.getType();
        StorageProvider storageProvider = this.storageProviderFactory.getStorageProvider(storageAccountId);
        if (type.equals((Object)StorageProviderType.AMAZON_S3)) {
            S3StorageProvider unwrappedS3Provider = new S3StorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            CloudFrontService cfService = S3ProviderUtil.getCloudFrontService((String)username, (String)password);
            taskProvider = new S3TaskProvider(storageProvider, unwrappedS3Provider, s3Client, cfService);
        } else if (type.equals((Object)StorageProviderType.AMAZON_GLACIER)) {
            GlacierStorageProvider unwrappedGlacierProvider = new GlacierStorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            taskProvider = new GlacierTaskProvider(storageProvider, unwrappedGlacierProvider, s3Client);
        } else if (type.equals((Object)StorageProviderType.SNAPSHOT)) {
            SnapshotStorageProvider unwrappedSnapshotProvider = new SnapshotStorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            String dcHost = storageAccountManager.getInstanceHost();
            String dcPort = storageAccountManager.getInstancePort();
            String dcAccountName = storageAccountManager.getAccountName();
            String dcSnapshotUser = (String)account.getOptions().get(StorageAccount.OPTS.SNAPSHOT_USER.name());
            String bridgeHost = (String)account.getOptions().get(StorageAccount.OPTS.BRIDGE_HOST.name());
            String bridgePort = (String)account.getOptions().get(StorageAccount.OPTS.BRIDGE_PORT.name());
            String bridgeUser = (String)account.getOptions().get(StorageAccount.OPTS.BRIDGE_USER.name());
            String bridgePass = (String)account.getOptions().get(StorageAccount.OPTS.BRIDGE_PASS.name());
            taskProvider = new SnapshotTaskProvider(storageProvider, unwrappedSnapshotProvider, s3Client, dcHost, dcPort, storageAccountId, dcAccountName, dcSnapshotUser, bridgeHost, bridgePort, bridgeUser, bridgePass);
        } else {
            throw new TaskException("No TaskProvider is available for " + type);
        }
        return taskProvider;
    }
}

