/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.io.InputStream;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.util.InitConfigParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProviderFactoryBase {
    private Logger log = LoggerFactory.getLogger(ProviderFactoryBase.class);
    private StorageAccountManager storageAccountManager;
    private DuraStoreInitConfig initConfig;

    public ProviderFactoryBase(StorageAccountManager storageAccountManager) {
        this.storageAccountManager = storageAccountManager;
    }

    @Deprecated
    public void initialize(InputStream initXml, String instanceHost, String instancePort) throws StorageException {
        if (initXml == null) {
            throw new IllegalArgumentException("XML containing account information");
        }
        DuraStoreInitConfig initConfig = InitConfigParser.parseInitXml((InputStream)initXml);
        this.initialize(initConfig, instanceHost, instancePort);
    }

    public void initialize(DuraStoreInitConfig initConfig, String instanceHost, String instancePort) throws StorageException {
        this.initConfig = initConfig;
        this.storageAccountManager.initialize(initConfig.getStorageAccounts());
        this.storageAccountManager.setEnvironment(instanceHost, instancePort);
    }

    protected StorageAccountManager getAccountManager() throws StorageException {
        this.checkInitialized();
        return this.storageAccountManager;
    }

    protected DuraStoreInitConfig getInitConfig() throws StorageException {
        this.checkInitialized();
        return this.initConfig;
    }

    public boolean isInitialized() {
        try {
            this.checkInitialized();
            return true;
        }
        catch (StorageException e) {
            return false;
        }
    }

    private void checkInitialized() throws StorageException {
        if (this.storageAccountManager == null || !this.storageAccountManager.isInitialized()) {
            String error = "DuraStore must be initialized with an XML file containing storage account information before any further requests can be fulfilled.";
            throw new StorageException(error);
        }
    }
}

