/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.duracloud.common.model.AclType;

public abstract class BaseRest {
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    public static final String XML = "application/xml";
    public static final String HTML = "text/html";
    public static final MediaType APPLICATION_XML = MediaType.APPLICATION_XML_TYPE;
    public static final MediaType TEXT_PLAIN = MediaType.TEXT_PLAIN_TYPE;
    public static final String DEFAULT_MIME = "application/octet-stream";
    public static final String HEADER_PREFIX = "x-dura-meta-";
    public static final String SPACE_ACL_HEADER = "x-dura-meta-acl-";
    public static final String CONTENT_MIMETYPE_HEADER = "x-dura-meta-content-mimetype";
    public static final String COPY_SOURCE_HEADER = "x-dura-meta-copy-source";
    public static final String COPY_SOURCE_STORE_HEADER = "x-dura-meta-copy-source-store";
    public static final String APP_NAME = "DuraStore";

    protected Map<String, String> getUserProperties(String ... exclusions) {
        return this.doGetUserProperties(HEADER_PREFIX, exclusions);
    }

    protected Map<String, String> getUserProperties() {
        return this.doGetUserProperties(HEADER_PREFIX, new String[0]);
    }

    protected Map<String, AclType> getSpaceACLs() {
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        Map<String, String> aclProps = this.doGetUserProperties(SPACE_ACL_HEADER, new String[0]);
        for (String key : aclProps.keySet()) {
            String val = aclProps.get(key);
            acls.put(key, AclType.valueOf((String)val));
        }
        return acls;
    }

    private Map<String, String> doGetUserProperties(String prefix, String ... exclusions) {
        MultivaluedMap rHeaders = this.headers.getRequestHeaders();
        HashMap<String, String> userProperties = new HashMap<String, String>();
        for (String headerName : rHeaders.keySet()) {
            if (!headerName.startsWith(prefix)) continue;
            boolean include = true;
            for (String exclusion : exclusions) {
                if (!exclusion.equals(headerName)) continue;
                include = false;
            }
            if (!include) continue;
            String noPrefixName = headerName.substring(HEADER_PREFIX.length());
            userProperties.put(noPrefixName, (String)rHeaders.getFirst((Object)headerName));
        }
        return userProperties;
    }

    protected Response responseOk() {
        return Response.ok().build();
    }

    protected Response responseOk(String text) {
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    protected Response responseOkStream(InputStream text) {
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    protected Response responseOkXml(String xml) {
        return Response.ok((Object)xml, (MediaType)APPLICATION_XML).build();
    }

    protected Response responseOkXmlStream(InputStream xml) {
        return Response.ok((Object)xml, (MediaType)APPLICATION_XML).build();
    }

    protected Response responseNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected Response responseNotFound(String msg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).build();
    }

    protected Response responseBadRequest(Exception e) {
        return this.responseBad(e, Response.Status.BAD_REQUEST);
    }

    protected Response responseBad(Exception e) {
        return this.responseBad(e, Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response responseBad(Exception e, Response.Status status) {
        String text = e.getMessage() == null ? "null" : e.getMessage();
        return this.responseBad(text, status);
    }

    protected Response responseBad(String msg, Response.Status status) {
        String entity = msg == null ? "null" : msg;
        return Response.status((Response.Status)status).entity((Object)entity).build();
    }

    protected String getSubdomain() {
        String subdomain = this.request.getHeader("X-FORWARDED-HOST");
        if (subdomain == null) {
            subdomain = this.request.getServerName();
        }
        subdomain = subdomain.split("[.]")[0];
        return subdomain;
    }
}

