/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.Map;
import org.duracloud.durastore.util.ProviderFactoryBase;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.glaciertask.GlacierTaskProvider;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.S3TaskProvider;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.SnapshotTaskProvider;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskProvider;
import org.duracloud.storage.util.StorageProviderFactory;

public class TaskProviderFactory
extends ProviderFactoryBase {
    private StorageProviderFactory storageProviderFactory;
    private ManifestStore manifestStore;

    public TaskProviderFactory(StorageAccountManager storageAccountManager, StorageProviderFactory storageProviderFactory, ManifestStore manifestStore) {
        super(storageAccountManager);
        this.storageProviderFactory = storageProviderFactory;
        this.manifestStore = manifestStore;
    }

    public TaskProvider getTaskProvider() {
        return this.getTaskProvider(null);
    }

    public TaskProvider getTaskProvider(String storageAccountId) throws TaskException {
        GlacierTaskProvider taskProvider;
        StorageAccountManager storageAccountManager = this.getAccountManager();
        StorageAccount account = storageAccountManager.getStorageAccount(storageAccountId);
        if (account == null) {
            account = storageAccountManager.getPrimaryStorageAccount();
            storageAccountId = account.getId();
        }
        String username = account.getUsername();
        String password = account.getPassword();
        StorageProviderType type = account.getType();
        StorageProvider storageProvider = this.storageProviderFactory.getStorageProvider(storageAccountId);
        if (type.equals((Object)StorageProviderType.AMAZON_S3)) {
            S3StorageProvider unwrappedS3Provider = new S3StorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            AmazonCloudFrontClient cfClient = S3ProviderUtil.getAmazonCloudFrontClient((String)username, (String)password);
            Map opts = account.getOptions();
            String cfAccountId = (String)opts.get(StorageAccount.OPTS.CF_ACCOUNT_ID.name());
            String cfKeyId = (String)opts.get(StorageAccount.OPTS.CF_KEY_ID.name());
            String cfKeyPath = (String)opts.get(StorageAccount.OPTS.CF_KEY_PATH.name());
            taskProvider = new S3TaskProvider(storageProvider, unwrappedS3Provider, s3Client, cfClient, cfAccountId, cfKeyId, cfKeyPath);
        } else if (type.equals((Object)StorageProviderType.AMAZON_GLACIER)) {
            GlacierStorageProvider unwrappedGlacierProvider = new GlacierStorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            taskProvider = new GlacierTaskProvider(storageProvider, unwrappedGlacierProvider, s3Client);
        } else if (type.equals((Object)StorageProviderType.SNAPSHOT)) {
            SnapshotStorageProvider unwrappedSnapshotProvider = new SnapshotStorageProvider(username, password);
            AmazonS3Client s3Client = S3ProviderUtil.getAmazonS3Client((String)username, (String)password);
            String dcHost = storageAccountManager.getInstanceHost();
            String dcPort = storageAccountManager.getInstancePort();
            String dcAccountName = storageAccountManager.getAccountName();
            Map opts = account.getOptions();
            String dcSnapshotUser = (String)opts.get(StorageAccount.OPTS.SNAPSHOT_USER.name());
            String bridgeHost = (String)opts.get(StorageAccount.OPTS.BRIDGE_HOST.name());
            String bridgePort = (String)opts.get(StorageAccount.OPTS.BRIDGE_PORT.name());
            String bridgeUser = (String)opts.get(StorageAccount.OPTS.BRIDGE_USER.name());
            String bridgePass = (String)opts.get(StorageAccount.OPTS.BRIDGE_PASS.name());
            taskProvider = new SnapshotTaskProvider(storageProvider, unwrappedSnapshotProvider, s3Client, dcHost, dcPort, storageAccountId, dcAccountName, dcSnapshotUser, bridgeHost, bridgePort, bridgeUser, bridgePass, this.storageProviderFactory.getAuditQueue(), this.manifestStore);
        } else {
            throw new TaskException("No TaskProvider is available for " + type);
        }
        return taskProvider;
    }
}

